// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IdentityProtectionRoot;
import com.microsoft.graph.models.RiskyUser;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.RiskyUserCollectionRequestBuilder;
import com.microsoft.graph.requests.RiskyUserRequestBuilder;
import com.microsoft.graph.requests.RiskyUserCollectionRequest;
import com.microsoft.graph.requests.RiskyUserConfirmCompromisedRequestBuilder;
import com.microsoft.graph.requests.RiskyUserDismissRequestBuilder;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
import com.microsoft.graph.models.RiskyUserConfirmCompromisedParameterSet;
import com.microsoft.graph.models.RiskyUserDismissParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Risky User Collection Request Builder.
 */
public class RiskyUserCollectionRequestBuilder extends BaseCollectionRequestBuilder<RiskyUser, RiskyUserRequestBuilder, RiskyUserCollectionResponse, RiskyUserCollectionPage, RiskyUserCollectionRequest> {

    /**
     * The request builder for this collection of IdentityProtectionRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RiskyUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, RiskyUserRequestBuilder.class, RiskyUserCollectionRequest.class);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public RiskyUserConfirmCompromisedRequestBuilder confirmCompromised(@Nonnull final RiskyUserConfirmCompromisedParameterSet parameters) {
        return new RiskyUserConfirmCompromisedRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.confirmCompromised"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public RiskyUserDismissRequestBuilder dismiss(@Nonnull final RiskyUserDismissParameterSet parameters) {
        return new RiskyUserDismissRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.dismiss"), getClient(), null, parameters);
    }

    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
