// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SamlOrWsFedProvider;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Saml Or Ws Fed Provider Request.
 */
public class SamlOrWsFedProviderRequest extends BaseRequest<SamlOrWsFedProvider> {
	
    /**
     * The request for the SamlOrWsFedProvider
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public SamlOrWsFedProviderRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends SamlOrWsFedProvider> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the SamlOrWsFedProvider
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SamlOrWsFedProviderRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SamlOrWsFedProvider.class);
    }

    /**
     * Gets the SamlOrWsFedProvider from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SamlOrWsFedProvider> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SamlOrWsFedProvider from the service
     *
     * @return the SamlOrWsFedProvider from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SamlOrWsFedProvider get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SamlOrWsFedProvider> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SamlOrWsFedProvider delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SamlOrWsFedProvider with a source
     *
     * @param sourceSamlOrWsFedProvider the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SamlOrWsFedProvider> patchAsync(@Nonnull final SamlOrWsFedProvider sourceSamlOrWsFedProvider) {
        return sendAsync(HttpMethod.PATCH, sourceSamlOrWsFedProvider);
    }

    /**
     * Patches this SamlOrWsFedProvider with a source
     *
     * @param sourceSamlOrWsFedProvider the source object with updates
     * @return the updated SamlOrWsFedProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SamlOrWsFedProvider patch(@Nonnull final SamlOrWsFedProvider sourceSamlOrWsFedProvider) throws ClientException {
        return send(HttpMethod.PATCH, sourceSamlOrWsFedProvider);
    }

    /**
     * Creates a SamlOrWsFedProvider with a new object
     *
     * @param newSamlOrWsFedProvider the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SamlOrWsFedProvider> postAsync(@Nonnull final SamlOrWsFedProvider newSamlOrWsFedProvider) {
        return sendAsync(HttpMethod.POST, newSamlOrWsFedProvider);
    }

    /**
     * Creates a SamlOrWsFedProvider with a new object
     *
     * @param newSamlOrWsFedProvider the new object to create
     * @return the created SamlOrWsFedProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SamlOrWsFedProvider post(@Nonnull final SamlOrWsFedProvider newSamlOrWsFedProvider) throws ClientException {
        return send(HttpMethod.POST, newSamlOrWsFedProvider);
    }

    /**
     * Creates a SamlOrWsFedProvider with a new object
     *
     * @param newSamlOrWsFedProvider the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SamlOrWsFedProvider> putAsync(@Nonnull final SamlOrWsFedProvider newSamlOrWsFedProvider) {
        return sendAsync(HttpMethod.PUT, newSamlOrWsFedProvider);
    }

    /**
     * Creates a SamlOrWsFedProvider with a new object
     *
     * @param newSamlOrWsFedProvider the object to create/update
     * @return the created SamlOrWsFedProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SamlOrWsFedProvider put(@Nonnull final SamlOrWsFedProvider newSamlOrWsFedProvider) throws ClientException {
        return send(HttpMethod.PUT, newSamlOrWsFedProvider);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SamlOrWsFedProviderRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SamlOrWsFedProviderRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

