// Template Source: BaseMethodCollectionPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ServicePrincipal;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.DeltaCollectionPage;
import com.microsoft.graph.requests.ServicePrincipalDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.ServicePrincipalDeltaCollectionPage;
import com.microsoft.graph.requests.ServicePrincipalDeltaCollectionResponse;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Principal Delta Collection Page.
 */
public class ServicePrincipalDeltaCollectionPage extends DeltaCollectionPage<ServicePrincipal, ServicePrincipalDeltaCollectionRequestBuilder> {

    /**
     * A collection page for ServicePrincipal.
     *
     * @param response The serialized ServicePrincipalDeltaCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public ServicePrincipalDeltaCollectionPage(@Nonnull final ServicePrincipalDeltaCollectionResponse response, @Nonnull final ServicePrincipalDeltaCollectionRequestBuilder builder) {
       super(response, builder);
    }

	/**
     * Creates the collection page for ServicePrincipalDelta
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public ServicePrincipalDeltaCollectionPage(@Nonnull final java.util.List<ServicePrincipal> pageContents, @Nullable final ServicePrincipalDeltaCollectionRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
