// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TeamworkBot;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teamwork Bot Request.
 */
public class TeamworkBotRequest extends BaseRequest<TeamworkBot> {
	
    /**
     * The request for the TeamworkBot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamworkBotRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamworkBot.class);
    }

    /**
     * Gets the TeamworkBot from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkBot> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TeamworkBot from the service
     *
     * @return the TeamworkBot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkBot get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkBot> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TeamworkBot delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TeamworkBot with a source
     *
     * @param sourceTeamworkBot the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkBot> patchAsync(@Nonnull final TeamworkBot sourceTeamworkBot) {
        return sendAsync(HttpMethod.PATCH, sourceTeamworkBot);
    }

    /**
     * Patches this TeamworkBot with a source
     *
     * @param sourceTeamworkBot the source object with updates
     * @return the updated TeamworkBot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkBot patch(@Nonnull final TeamworkBot sourceTeamworkBot) throws ClientException {
        return send(HttpMethod.PATCH, sourceTeamworkBot);
    }

    /**
     * Creates a TeamworkBot with a new object
     *
     * @param newTeamworkBot the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkBot> postAsync(@Nonnull final TeamworkBot newTeamworkBot) {
        return sendAsync(HttpMethod.POST, newTeamworkBot);
    }

    /**
     * Creates a TeamworkBot with a new object
     *
     * @param newTeamworkBot the new object to create
     * @return the created TeamworkBot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkBot post(@Nonnull final TeamworkBot newTeamworkBot) throws ClientException {
        return send(HttpMethod.POST, newTeamworkBot);
    }

    /**
     * Creates a TeamworkBot with a new object
     *
     * @param newTeamworkBot the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkBot> putAsync(@Nonnull final TeamworkBot newTeamworkBot) {
        return sendAsync(HttpMethod.PUT, newTeamworkBot);
    }

    /**
     * Creates a TeamworkBot with a new object
     *
     * @param newTeamworkBot the object to create/update
     * @return the created TeamworkBot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkBot put(@Nonnull final TeamworkBot newTeamworkBot) throws ClientException {
        return send(HttpMethod.PUT, newTeamworkBot);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TeamworkBotRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TeamworkBotRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

