// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TeamworkTagMember;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teamwork Tag Member Request.
 */
public class TeamworkTagMemberRequest extends BaseRequest<TeamworkTagMember> {
	
    /**
     * The request for the TeamworkTagMember
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamworkTagMemberRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamworkTagMember.class);
    }

    /**
     * Gets the TeamworkTagMember from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkTagMember> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TeamworkTagMember from the service
     *
     * @return the TeamworkTagMember from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkTagMember get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkTagMember> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TeamworkTagMember delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TeamworkTagMember with a source
     *
     * @param sourceTeamworkTagMember the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkTagMember> patchAsync(@Nonnull final TeamworkTagMember sourceTeamworkTagMember) {
        return sendAsync(HttpMethod.PATCH, sourceTeamworkTagMember);
    }

    /**
     * Patches this TeamworkTagMember with a source
     *
     * @param sourceTeamworkTagMember the source object with updates
     * @return the updated TeamworkTagMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkTagMember patch(@Nonnull final TeamworkTagMember sourceTeamworkTagMember) throws ClientException {
        return send(HttpMethod.PATCH, sourceTeamworkTagMember);
    }

    /**
     * Creates a TeamworkTagMember with a new object
     *
     * @param newTeamworkTagMember the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkTagMember> postAsync(@Nonnull final TeamworkTagMember newTeamworkTagMember) {
        return sendAsync(HttpMethod.POST, newTeamworkTagMember);
    }

    /**
     * Creates a TeamworkTagMember with a new object
     *
     * @param newTeamworkTagMember the new object to create
     * @return the created TeamworkTagMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkTagMember post(@Nonnull final TeamworkTagMember newTeamworkTagMember) throws ClientException {
        return send(HttpMethod.POST, newTeamworkTagMember);
    }

    /**
     * Creates a TeamworkTagMember with a new object
     *
     * @param newTeamworkTagMember the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkTagMember> putAsync(@Nonnull final TeamworkTagMember newTeamworkTagMember) {
        return sendAsync(HttpMethod.PUT, newTeamworkTagMember);
    }

    /**
     * Creates a TeamworkTagMember with a new object
     *
     * @param newTeamworkTagMember the object to create/update
     * @return the created TeamworkTagMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkTagMember put(@Nonnull final TeamworkTagMember newTeamworkTagMember) throws ClientException {
        return send(HttpMethod.PUT, newTeamworkTagMember);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TeamworkTagMemberRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TeamworkTagMemberRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

