// Template Source: BaseEntityCollectionRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.RbacApplication;
import com.microsoft.graph.models.UnifiedRoleAssignmentScheduleInstance;
import com.microsoft.graph.models.RoleAssignmentScheduleInstanceFilterByCurrentUserOptions;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleInstanceCollectionResponse;
import com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleInstanceCollectionRequestBuilder;
import com.microsoft.graph.requests.UnifiedRoleAssignmentScheduleInstanceCollectionRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Assignment Schedule Instance Collection Request.
 */
public class UnifiedRoleAssignmentScheduleInstanceCollectionRequest extends BaseEntityCollectionRequest<UnifiedRoleAssignmentScheduleInstance, UnifiedRoleAssignmentScheduleInstanceCollectionResponse, UnifiedRoleAssignmentScheduleInstanceCollectionPage> {

    /**
     * The request builder for this collection of UnifiedRoleAssignmentScheduleInstance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnifiedRoleAssignmentScheduleInstanceCollectionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UnifiedRoleAssignmentScheduleInstanceCollectionResponse.class, UnifiedRoleAssignmentScheduleInstanceCollectionPage.class, UnifiedRoleAssignmentScheduleInstanceCollectionRequestBuilder.class);
    }

    /**
     * Creates a new UnifiedRoleAssignmentScheduleInstance
     * @param newUnifiedRoleAssignmentScheduleInstance the UnifiedRoleAssignmentScheduleInstance to create
     * @return a future with the created object
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleAssignmentScheduleInstance> postAsync(@Nonnull final UnifiedRoleAssignmentScheduleInstance newUnifiedRoleAssignmentScheduleInstance) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new UnifiedRoleAssignmentScheduleInstanceRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .postAsync(newUnifiedRoleAssignmentScheduleInstance);
    }

    /**
     * Creates a new UnifiedRoleAssignmentScheduleInstance
     * @param newUnifiedRoleAssignmentScheduleInstance the UnifiedRoleAssignmentScheduleInstance to create
     * @return the newly created object
     */
    @Nonnull
    public UnifiedRoleAssignmentScheduleInstance post(@Nonnull final UnifiedRoleAssignmentScheduleInstance newUnifiedRoleAssignmentScheduleInstance) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new UnifiedRoleAssignmentScheduleInstanceRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newUnifiedRoleAssignmentScheduleInstance);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    @Nonnull
    public UnifiedRoleAssignmentScheduleInstanceCollectionRequest expand(@Nonnull final String value) {
        addExpandOption(value);
        return this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    @Nonnull
    public UnifiedRoleAssignmentScheduleInstanceCollectionRequest filter(@Nonnull final String value) {
        addFilterOption(value);
        return this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the order by clause
     * @return the updated request
     */
    @Nonnull
    public UnifiedRoleAssignmentScheduleInstanceCollectionRequest orderBy(@Nonnull final String value) {
        addOrderByOption(value);
        return this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    @Nonnull
    public UnifiedRoleAssignmentScheduleInstanceCollectionRequest select(@Nonnull final String value) {
        addSelectOption(value);
        return this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    @Nonnull
    public UnifiedRoleAssignmentScheduleInstanceCollectionRequest top(final int value) {
        addTopOption(value);
        return this;
    }

    /**
     * Sets the count value for the request
     *
     * @param value whether or not to return the count of objects with the request
     * @return the updated request
     */
    @Nonnull
    public UnifiedRoleAssignmentScheduleInstanceCollectionRequest count(final boolean value) {
        addCountOption(value);
        return this;
    }
    /**
     * Sets the count value to true for the request
     *
     * @return the updated request
     */
    @Nonnull
    public UnifiedRoleAssignmentScheduleInstanceCollectionRequest count() {
        addCountOption(true);
        return this;
    }
    /**
     * Sets the skip value for the request
     *
     * @param value of the number of items to skip
     * @return the updated request
     */
    @Nonnull
    public UnifiedRoleAssignmentScheduleInstanceCollectionRequest skip(final int value) {
        addSkipOption(value);
        return this;
    }


    /**
     * Add Skip token for pagination
     * @param skipToken - Token for pagination
     * @return the updated request
     */
    @Nonnull
    public UnifiedRoleAssignmentScheduleInstanceCollectionRequest skipToken(@Nonnull final String skipToken) {
    	addSkipTokenOption(skipToken);
        return this;
    }
}

