// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics App Health App Performance By OSVersion Request.
 */
public class UserExperienceAnalyticsAppHealthAppPerformanceByOSVersionRequest extends BaseRequest<UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion> {
	
    /**
     * The request for the UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion.class);
    }

    /**
     * Gets the UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion from the service
     *
     * @return the UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion with a source
     *
     * @param sourceUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion> patchAsync(@Nonnull final UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion sourceUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion) {
        return sendAsync(HttpMethod.PATCH, sourceUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion);
    }

    /**
     * Patches this UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion with a source
     *
     * @param sourceUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion the source object with updates
     * @return the updated UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion patch(@Nonnull final UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion sourceUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion> postAsync(@Nonnull final UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion newUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion) {
        return sendAsync(HttpMethod.POST, newUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion the new object to create
     * @return the created UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion post(@Nonnull final UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion newUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion) throws ClientException {
        return send(HttpMethod.POST, newUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion> putAsync(@Nonnull final UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion newUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion) {
        return sendAsync(HttpMethod.PUT, newUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion the object to create/update
     * @return the created UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion put(@Nonnull final UserExperienceAnalyticsAppHealthAppPerformanceByOSVersion newUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion) throws ClientException {
        return send(HttpMethod.PUT, newUserExperienceAnalyticsAppHealthAppPerformanceByOSVersion);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

