// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserExperienceAnalyticsScoreHistory;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics Score History Request.
 */
public class UserExperienceAnalyticsScoreHistoryRequest extends BaseRequest<UserExperienceAnalyticsScoreHistory> {
	
    /**
     * The request for the UserExperienceAnalyticsScoreHistory
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserExperienceAnalyticsScoreHistoryRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserExperienceAnalyticsScoreHistory.class);
    }

    /**
     * Gets the UserExperienceAnalyticsScoreHistory from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsScoreHistory> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserExperienceAnalyticsScoreHistory from the service
     *
     * @return the UserExperienceAnalyticsScoreHistory from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsScoreHistory get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsScoreHistory> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserExperienceAnalyticsScoreHistory delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserExperienceAnalyticsScoreHistory with a source
     *
     * @param sourceUserExperienceAnalyticsScoreHistory the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsScoreHistory> patchAsync(@Nonnull final UserExperienceAnalyticsScoreHistory sourceUserExperienceAnalyticsScoreHistory) {
        return sendAsync(HttpMethod.PATCH, sourceUserExperienceAnalyticsScoreHistory);
    }

    /**
     * Patches this UserExperienceAnalyticsScoreHistory with a source
     *
     * @param sourceUserExperienceAnalyticsScoreHistory the source object with updates
     * @return the updated UserExperienceAnalyticsScoreHistory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsScoreHistory patch(@Nonnull final UserExperienceAnalyticsScoreHistory sourceUserExperienceAnalyticsScoreHistory) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserExperienceAnalyticsScoreHistory);
    }

    /**
     * Creates a UserExperienceAnalyticsScoreHistory with a new object
     *
     * @param newUserExperienceAnalyticsScoreHistory the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsScoreHistory> postAsync(@Nonnull final UserExperienceAnalyticsScoreHistory newUserExperienceAnalyticsScoreHistory) {
        return sendAsync(HttpMethod.POST, newUserExperienceAnalyticsScoreHistory);
    }

    /**
     * Creates a UserExperienceAnalyticsScoreHistory with a new object
     *
     * @param newUserExperienceAnalyticsScoreHistory the new object to create
     * @return the created UserExperienceAnalyticsScoreHistory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsScoreHistory post(@Nonnull final UserExperienceAnalyticsScoreHistory newUserExperienceAnalyticsScoreHistory) throws ClientException {
        return send(HttpMethod.POST, newUserExperienceAnalyticsScoreHistory);
    }

    /**
     * Creates a UserExperienceAnalyticsScoreHistory with a new object
     *
     * @param newUserExperienceAnalyticsScoreHistory the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsScoreHistory> putAsync(@Nonnull final UserExperienceAnalyticsScoreHistory newUserExperienceAnalyticsScoreHistory) {
        return sendAsync(HttpMethod.PUT, newUserExperienceAnalyticsScoreHistory);
    }

    /**
     * Creates a UserExperienceAnalyticsScoreHistory with a new object
     *
     * @param newUserExperienceAnalyticsScoreHistory the object to create/update
     * @return the created UserExperienceAnalyticsScoreHistory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsScoreHistory put(@Nonnull final UserExperienceAnalyticsScoreHistory newUserExperienceAnalyticsScoreHistory) throws ClientException {
        return send(HttpMethod.PUT, newUserExperienceAnalyticsScoreHistory);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsScoreHistoryRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsScoreHistoryRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

