// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserExperienceAnalyticsWorkFromAnywhereModelPerformance;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics Work From Anywhere Model Performance Request.
 */
public class UserExperienceAnalyticsWorkFromAnywhereModelPerformanceRequest extends BaseRequest<UserExperienceAnalyticsWorkFromAnywhereModelPerformance> {
	
    /**
     * The request for the UserExperienceAnalyticsWorkFromAnywhereModelPerformance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformanceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserExperienceAnalyticsWorkFromAnywhereModelPerformance.class);
    }

    /**
     * Gets the UserExperienceAnalyticsWorkFromAnywhereModelPerformance from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsWorkFromAnywhereModelPerformance> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserExperienceAnalyticsWorkFromAnywhereModelPerformance from the service
     *
     * @return the UserExperienceAnalyticsWorkFromAnywhereModelPerformance from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsWorkFromAnywhereModelPerformance> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserExperienceAnalyticsWorkFromAnywhereModelPerformance with a source
     *
     * @param sourceUserExperienceAnalyticsWorkFromAnywhereModelPerformance the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsWorkFromAnywhereModelPerformance> patchAsync(@Nonnull final UserExperienceAnalyticsWorkFromAnywhereModelPerformance sourceUserExperienceAnalyticsWorkFromAnywhereModelPerformance) {
        return sendAsync(HttpMethod.PATCH, sourceUserExperienceAnalyticsWorkFromAnywhereModelPerformance);
    }

    /**
     * Patches this UserExperienceAnalyticsWorkFromAnywhereModelPerformance with a source
     *
     * @param sourceUserExperienceAnalyticsWorkFromAnywhereModelPerformance the source object with updates
     * @return the updated UserExperienceAnalyticsWorkFromAnywhereModelPerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance patch(@Nonnull final UserExperienceAnalyticsWorkFromAnywhereModelPerformance sourceUserExperienceAnalyticsWorkFromAnywhereModelPerformance) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserExperienceAnalyticsWorkFromAnywhereModelPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsWorkFromAnywhereModelPerformance with a new object
     *
     * @param newUserExperienceAnalyticsWorkFromAnywhereModelPerformance the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsWorkFromAnywhereModelPerformance> postAsync(@Nonnull final UserExperienceAnalyticsWorkFromAnywhereModelPerformance newUserExperienceAnalyticsWorkFromAnywhereModelPerformance) {
        return sendAsync(HttpMethod.POST, newUserExperienceAnalyticsWorkFromAnywhereModelPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsWorkFromAnywhereModelPerformance with a new object
     *
     * @param newUserExperienceAnalyticsWorkFromAnywhereModelPerformance the new object to create
     * @return the created UserExperienceAnalyticsWorkFromAnywhereModelPerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance post(@Nonnull final UserExperienceAnalyticsWorkFromAnywhereModelPerformance newUserExperienceAnalyticsWorkFromAnywhereModelPerformance) throws ClientException {
        return send(HttpMethod.POST, newUserExperienceAnalyticsWorkFromAnywhereModelPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsWorkFromAnywhereModelPerformance with a new object
     *
     * @param newUserExperienceAnalyticsWorkFromAnywhereModelPerformance the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsWorkFromAnywhereModelPerformance> putAsync(@Nonnull final UserExperienceAnalyticsWorkFromAnywhereModelPerformance newUserExperienceAnalyticsWorkFromAnywhereModelPerformance) {
        return sendAsync(HttpMethod.PUT, newUserExperienceAnalyticsWorkFromAnywhereModelPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsWorkFromAnywhereModelPerformance with a new object
     *
     * @param newUserExperienceAnalyticsWorkFromAnywhereModelPerformance the object to create/update
     * @return the created UserExperienceAnalyticsWorkFromAnywhereModelPerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsWorkFromAnywhereModelPerformance put(@Nonnull final UserExperienceAnalyticsWorkFromAnywhereModelPerformance newUserExperienceAnalyticsWorkFromAnywhereModelPerformance) throws ClientException {
        return send(HttpMethod.PUT, newUserExperienceAnalyticsWorkFromAnywhereModelPerformance);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsWorkFromAnywhereModelPerformanceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsWorkFromAnywhereModelPerformanceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

