// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserFlowLanguageConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Flow Language Configuration Request Builder.
 */
public class UserFlowLanguageConfigurationRequestBuilder extends BaseRequestBuilder<UserFlowLanguageConfiguration> {

    /**
     * The request builder for the UserFlowLanguageConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserFlowLanguageConfigurationRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the UserFlowLanguageConfigurationRequest instance
     */
    @Nonnull
    public UserFlowLanguageConfigurationRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the UserFlowLanguageConfigurationRequest instance
     */
    @Nonnull
    public UserFlowLanguageConfigurationRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.UserFlowLanguageConfigurationRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the UserFlowLanguagePage collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UserFlowLanguagePageCollectionRequestBuilder defaultPages() {
        return new com.microsoft.graph.requests.UserFlowLanguagePageCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("defaultPages"), getClient(), null);
    }

    /**
     * Gets a request builder for the UserFlowLanguagePage item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UserFlowLanguagePageRequestBuilder defaultPages(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UserFlowLanguagePageRequestBuilder(getRequestUrlWithAdditionalSegment("defaultPages") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UserFlowLanguagePage collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UserFlowLanguagePageCollectionRequestBuilder overridesPages() {
        return new com.microsoft.graph.requests.UserFlowLanguagePageCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("overridesPages"), getClient(), null);
    }

    /**
     * Gets a request builder for the UserFlowLanguagePage item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UserFlowLanguagePageRequestBuilder overridesPages(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UserFlowLanguagePageRequestBuilder(getRequestUrlWithAdditionalSegment("overridesPages") + "/" + id, getClient(), null);
    }
}
