// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserRegistrationDetails;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Registration Details Request.
 */
public class UserRegistrationDetailsRequest extends BaseRequest<UserRegistrationDetails> {
	
    /**
     * The request for the UserRegistrationDetails
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserRegistrationDetailsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserRegistrationDetails.class);
    }

    /**
     * Gets the UserRegistrationDetails from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserRegistrationDetails> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserRegistrationDetails from the service
     *
     * @return the UserRegistrationDetails from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserRegistrationDetails get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserRegistrationDetails> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserRegistrationDetails delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserRegistrationDetails with a source
     *
     * @param sourceUserRegistrationDetails the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserRegistrationDetails> patchAsync(@Nonnull final UserRegistrationDetails sourceUserRegistrationDetails) {
        return sendAsync(HttpMethod.PATCH, sourceUserRegistrationDetails);
    }

    /**
     * Patches this UserRegistrationDetails with a source
     *
     * @param sourceUserRegistrationDetails the source object with updates
     * @return the updated UserRegistrationDetails
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserRegistrationDetails patch(@Nonnull final UserRegistrationDetails sourceUserRegistrationDetails) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserRegistrationDetails);
    }

    /**
     * Creates a UserRegistrationDetails with a new object
     *
     * @param newUserRegistrationDetails the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserRegistrationDetails> postAsync(@Nonnull final UserRegistrationDetails newUserRegistrationDetails) {
        return sendAsync(HttpMethod.POST, newUserRegistrationDetails);
    }

    /**
     * Creates a UserRegistrationDetails with a new object
     *
     * @param newUserRegistrationDetails the new object to create
     * @return the created UserRegistrationDetails
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserRegistrationDetails post(@Nonnull final UserRegistrationDetails newUserRegistrationDetails) throws ClientException {
        return send(HttpMethod.POST, newUserRegistrationDetails);
    }

    /**
     * Creates a UserRegistrationDetails with a new object
     *
     * @param newUserRegistrationDetails the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserRegistrationDetails> putAsync(@Nonnull final UserRegistrationDetails newUserRegistrationDetails) {
        return sendAsync(HttpMethod.PUT, newUserRegistrationDetails);
    }

    /**
     * Creates a UserRegistrationDetails with a new object
     *
     * @param newUserRegistrationDetails the object to create/update
     * @return the created UserRegistrationDetails
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserRegistrationDetails put(@Nonnull final UserRegistrationDetails newUserRegistrationDetails) throws ClientException {
        return send(HttpMethod.PUT, newUserRegistrationDetails);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserRegistrationDetailsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserRegistrationDetailsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

