// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserScopeTeamsAppInstallation;
import com.microsoft.graph.models.TeamsAppPermissionSet;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.TeamsAppInstallationUpgradeParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Scope Teams App Installation Request Builder.
 */
public class UserScopeTeamsAppInstallationRequestBuilder extends BaseRequestBuilder<UserScopeTeamsAppInstallation> {

    /**
     * The request builder for the UserScopeTeamsAppInstallation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserScopeTeamsAppInstallationRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the UserScopeTeamsAppInstallationRequest instance
     */
    @Nonnull
    public UserScopeTeamsAppInstallationRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the UserScopeTeamsAppInstallationRequest instance
     */
    @Nonnull
    public UserScopeTeamsAppInstallationRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.UserScopeTeamsAppInstallationRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for TeamsApp
     *
     * @return the TeamsAppWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamsAppWithReferenceRequestBuilder teamsApp() {
        return new com.microsoft.graph.requests.TeamsAppWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("teamsApp"), getClient(), null);
    }

    /**
     * Gets the request builder for TeamsAppDefinition
     *
     * @return the TeamsAppDefinitionWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamsAppDefinitionWithReferenceRequestBuilder teamsAppDefinition() {
        return new com.microsoft.graph.requests.TeamsAppDefinitionWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("teamsAppDefinition"), getClient(), null);
    }

    /**
     * Gets the request builder for Chat
     *
     * @return the ChatWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.ChatWithReferenceRequestBuilder chat() {
        return new com.microsoft.graph.requests.ChatWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("chat"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public TeamsAppInstallationUpgradeRequestBuilder upgrade(@Nonnull final TeamsAppInstallationUpgradeParameterSet parameters) {
        return new TeamsAppInstallationUpgradeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.upgrade"), getClient(), null, parameters);
    }
}
