// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WebApp;
import com.microsoft.graph.models.MobileAppAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Web App Request.
 */
public class WebAppRequest extends BaseRequest<WebApp> {
	
    /**
     * The request for the WebApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WebAppRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WebApp.class);
    }

    /**
     * Gets the WebApp from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WebApp> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WebApp from the service
     *
     * @return the WebApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WebApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WebApp> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WebApp delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WebApp with a source
     *
     * @param sourceWebApp the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WebApp> patchAsync(@Nonnull final WebApp sourceWebApp) {
        return sendAsync(HttpMethod.PATCH, sourceWebApp);
    }

    /**
     * Patches this WebApp with a source
     *
     * @param sourceWebApp the source object with updates
     * @return the updated WebApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WebApp patch(@Nonnull final WebApp sourceWebApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceWebApp);
    }

    /**
     * Creates a WebApp with a new object
     *
     * @param newWebApp the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WebApp> postAsync(@Nonnull final WebApp newWebApp) {
        return sendAsync(HttpMethod.POST, newWebApp);
    }

    /**
     * Creates a WebApp with a new object
     *
     * @param newWebApp the new object to create
     * @return the created WebApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WebApp post(@Nonnull final WebApp newWebApp) throws ClientException {
        return send(HttpMethod.POST, newWebApp);
    }

    /**
     * Creates a WebApp with a new object
     *
     * @param newWebApp the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WebApp> putAsync(@Nonnull final WebApp newWebApp) {
        return sendAsync(HttpMethod.PUT, newWebApp);
    }

    /**
     * Creates a WebApp with a new object
     *
     * @param newWebApp the object to create/update
     * @return the created WebApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WebApp put(@Nonnull final WebApp newWebApp) throws ClientException {
        return send(HttpMethod.PUT, newWebApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WebAppRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WebAppRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

