// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Windows10MobileCompliancePolicy;
import com.microsoft.graph.models.DeviceCompliancePolicyAssignment;
import com.microsoft.graph.models.DeviceComplianceScheduledActionForRule;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows10Mobile Compliance Policy Request.
 */
public class Windows10MobileCompliancePolicyRequest extends BaseRequest<Windows10MobileCompliancePolicy> {
	
    /**
     * The request for the Windows10MobileCompliancePolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public Windows10MobileCompliancePolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Windows10MobileCompliancePolicy.class);
    }

    /**
     * Gets the Windows10MobileCompliancePolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10MobileCompliancePolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Windows10MobileCompliancePolicy from the service
     *
     * @return the Windows10MobileCompliancePolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows10MobileCompliancePolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10MobileCompliancePolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Windows10MobileCompliancePolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Windows10MobileCompliancePolicy with a source
     *
     * @param sourceWindows10MobileCompliancePolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10MobileCompliancePolicy> patchAsync(@Nonnull final Windows10MobileCompliancePolicy sourceWindows10MobileCompliancePolicy) {
        return sendAsync(HttpMethod.PATCH, sourceWindows10MobileCompliancePolicy);
    }

    /**
     * Patches this Windows10MobileCompliancePolicy with a source
     *
     * @param sourceWindows10MobileCompliancePolicy the source object with updates
     * @return the updated Windows10MobileCompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows10MobileCompliancePolicy patch(@Nonnull final Windows10MobileCompliancePolicy sourceWindows10MobileCompliancePolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindows10MobileCompliancePolicy);
    }

    /**
     * Creates a Windows10MobileCompliancePolicy with a new object
     *
     * @param newWindows10MobileCompliancePolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10MobileCompliancePolicy> postAsync(@Nonnull final Windows10MobileCompliancePolicy newWindows10MobileCompliancePolicy) {
        return sendAsync(HttpMethod.POST, newWindows10MobileCompliancePolicy);
    }

    /**
     * Creates a Windows10MobileCompliancePolicy with a new object
     *
     * @param newWindows10MobileCompliancePolicy the new object to create
     * @return the created Windows10MobileCompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows10MobileCompliancePolicy post(@Nonnull final Windows10MobileCompliancePolicy newWindows10MobileCompliancePolicy) throws ClientException {
        return send(HttpMethod.POST, newWindows10MobileCompliancePolicy);
    }

    /**
     * Creates a Windows10MobileCompliancePolicy with a new object
     *
     * @param newWindows10MobileCompliancePolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows10MobileCompliancePolicy> putAsync(@Nonnull final Windows10MobileCompliancePolicy newWindows10MobileCompliancePolicy) {
        return sendAsync(HttpMethod.PUT, newWindows10MobileCompliancePolicy);
    }

    /**
     * Creates a Windows10MobileCompliancePolicy with a new object
     *
     * @param newWindows10MobileCompliancePolicy the object to create/update
     * @return the created Windows10MobileCompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows10MobileCompliancePolicy put(@Nonnull final Windows10MobileCompliancePolicy newWindows10MobileCompliancePolicy) throws ClientException {
        return send(HttpMethod.PUT, newWindows10MobileCompliancePolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public Windows10MobileCompliancePolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public Windows10MobileCompliancePolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

