// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WindowsInformationProtectionPolicy;
import com.microsoft.graph.models.TargetedManagedAppPolicyAssignment;
import com.microsoft.graph.models.ManagedMobileApp;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Information Protection Policy Request.
 */
public class WindowsInformationProtectionPolicyRequest extends BaseRequest<WindowsInformationProtectionPolicy> {
	
    /**
     * The request for the WindowsInformationProtectionPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsInformationProtectionPolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsInformationProtectionPolicy.class);
    }

    /**
     * Gets the WindowsInformationProtectionPolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtectionPolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WindowsInformationProtectionPolicy from the service
     *
     * @return the WindowsInformationProtectionPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsInformationProtectionPolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtectionPolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WindowsInformationProtectionPolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsInformationProtectionPolicy with a source
     *
     * @param sourceWindowsInformationProtectionPolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtectionPolicy> patchAsync(@Nonnull final WindowsInformationProtectionPolicy sourceWindowsInformationProtectionPolicy) {
        return sendAsync(HttpMethod.PATCH, sourceWindowsInformationProtectionPolicy);
    }

    /**
     * Patches this WindowsInformationProtectionPolicy with a source
     *
     * @param sourceWindowsInformationProtectionPolicy the source object with updates
     * @return the updated WindowsInformationProtectionPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsInformationProtectionPolicy patch(@Nonnull final WindowsInformationProtectionPolicy sourceWindowsInformationProtectionPolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsInformationProtectionPolicy);
    }

    /**
     * Creates a WindowsInformationProtectionPolicy with a new object
     *
     * @param newWindowsInformationProtectionPolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtectionPolicy> postAsync(@Nonnull final WindowsInformationProtectionPolicy newWindowsInformationProtectionPolicy) {
        return sendAsync(HttpMethod.POST, newWindowsInformationProtectionPolicy);
    }

    /**
     * Creates a WindowsInformationProtectionPolicy with a new object
     *
     * @param newWindowsInformationProtectionPolicy the new object to create
     * @return the created WindowsInformationProtectionPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsInformationProtectionPolicy post(@Nonnull final WindowsInformationProtectionPolicy newWindowsInformationProtectionPolicy) throws ClientException {
        return send(HttpMethod.POST, newWindowsInformationProtectionPolicy);
    }

    /**
     * Creates a WindowsInformationProtectionPolicy with a new object
     *
     * @param newWindowsInformationProtectionPolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtectionPolicy> putAsync(@Nonnull final WindowsInformationProtectionPolicy newWindowsInformationProtectionPolicy) {
        return sendAsync(HttpMethod.PUT, newWindowsInformationProtectionPolicy);
    }

    /**
     * Creates a WindowsInformationProtectionPolicy with a new object
     *
     * @param newWindowsInformationProtectionPolicy the object to create/update
     * @return the created WindowsInformationProtectionPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsInformationProtectionPolicy put(@Nonnull final WindowsInformationProtectionPolicy newWindowsInformationProtectionPolicy) throws ClientException {
        return send(HttpMethod.PUT, newWindowsInformationProtectionPolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WindowsInformationProtectionPolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WindowsInformationProtectionPolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

