// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WindowsInformationProtection;
import com.microsoft.graph.models.TargetedManagedAppPolicyAssignment;
import com.microsoft.graph.models.ManagedMobileApp;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Information Protection Request.
 */
public class WindowsInformationProtectionRequest extends BaseRequest<WindowsInformationProtection> {
	
    /**
     * The request for the WindowsInformationProtection
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public WindowsInformationProtectionRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends WindowsInformationProtection> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the WindowsInformationProtection
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsInformationProtectionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsInformationProtection.class);
    }

    /**
     * Gets the WindowsInformationProtection from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtection> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WindowsInformationProtection from the service
     *
     * @return the WindowsInformationProtection from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsInformationProtection get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtection> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WindowsInformationProtection delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsInformationProtection with a source
     *
     * @param sourceWindowsInformationProtection the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtection> patchAsync(@Nonnull final WindowsInformationProtection sourceWindowsInformationProtection) {
        return sendAsync(HttpMethod.PATCH, sourceWindowsInformationProtection);
    }

    /**
     * Patches this WindowsInformationProtection with a source
     *
     * @param sourceWindowsInformationProtection the source object with updates
     * @return the updated WindowsInformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsInformationProtection patch(@Nonnull final WindowsInformationProtection sourceWindowsInformationProtection) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsInformationProtection);
    }

    /**
     * Creates a WindowsInformationProtection with a new object
     *
     * @param newWindowsInformationProtection the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtection> postAsync(@Nonnull final WindowsInformationProtection newWindowsInformationProtection) {
        return sendAsync(HttpMethod.POST, newWindowsInformationProtection);
    }

    /**
     * Creates a WindowsInformationProtection with a new object
     *
     * @param newWindowsInformationProtection the new object to create
     * @return the created WindowsInformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsInformationProtection post(@Nonnull final WindowsInformationProtection newWindowsInformationProtection) throws ClientException {
        return send(HttpMethod.POST, newWindowsInformationProtection);
    }

    /**
     * Creates a WindowsInformationProtection with a new object
     *
     * @param newWindowsInformationProtection the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsInformationProtection> putAsync(@Nonnull final WindowsInformationProtection newWindowsInformationProtection) {
        return sendAsync(HttpMethod.PUT, newWindowsInformationProtection);
    }

    /**
     * Creates a WindowsInformationProtection with a new object
     *
     * @param newWindowsInformationProtection the object to create/update
     * @return the created WindowsInformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsInformationProtection put(@Nonnull final WindowsInformationProtection newWindowsInformationProtection) throws ClientException {
        return send(HttpMethod.PUT, newWindowsInformationProtection);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WindowsInformationProtectionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WindowsInformationProtectionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

