// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoverySearch;
import com.microsoft.graph.security.models.EdiscoveryNoncustodialDataSource;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceCollectionResponse;
import com.microsoft.graph.security.models.EdiscoveryNoncustodialDataSource;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Noncustodial Data Source Collection With References Page.
 */
public class EdiscoveryNoncustodialDataSourceCollectionWithReferencesPage extends BaseCollectionPage<EdiscoveryNoncustodialDataSource, EdiscoveryNoncustodialDataSourceCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for EdiscoveryNoncustodialDataSource
     *
     * @param response the serialized EdiscoveryNoncustodialDataSourceCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public EdiscoveryNoncustodialDataSourceCollectionWithReferencesPage(@Nonnull final EdiscoveryNoncustodialDataSourceCollectionResponse response, @Nullable final EdiscoveryNoncustodialDataSourceCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for EdiscoveryNoncustodialDataSource
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public EdiscoveryNoncustodialDataSourceCollectionWithReferencesPage(@Nonnull final java.util.List<EdiscoveryNoncustodialDataSource> pageContents, @Nullable final EdiscoveryNoncustodialDataSourceCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
