// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Host;
import com.microsoft.graph.security.models.HostPair;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.HostPairCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.HostPairCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.HostPairCollectionResponse;
import com.microsoft.graph.security.models.HostPair;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Pair Collection With References Page.
 */
public class HostPairCollectionWithReferencesPage extends BaseCollectionPage<HostPair, HostPairCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for HostPair
     *
     * @param response the serialized HostPairCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public HostPairCollectionWithReferencesPage(@Nonnull final HostPairCollectionResponse response, @Nullable final HostPairCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for HostPair
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public HostPairCollectionWithReferencesPage(@Nonnull final java.util.List<HostPair> pageContents, @Nullable final HostPairCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
