// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Host;
import com.microsoft.graph.security.models.HostSslCertificate;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.HostSslCertificateCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.HostSslCertificateCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.HostSslCertificateCollectionResponse;
import com.microsoft.graph.security.models.HostSslCertificate;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Ssl Certificate Collection With References Page.
 */
public class HostSslCertificateCollectionWithReferencesPage extends BaseCollectionPage<HostSslCertificate, HostSslCertificateCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for HostSslCertificate
     *
     * @param response the serialized HostSslCertificateCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public HostSslCertificateCollectionWithReferencesPage(@Nonnull final HostSslCertificateCollectionResponse response, @Nullable final HostSslCertificateCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for HostSslCertificate
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public HostSslCertificateCollectionWithReferencesPage(@Nonnull final java.util.List<HostSslCertificate> pageContents, @Nullable final HostSslCertificateCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
