// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Amazon Resource Evidence.
 */
public class AmazonResourceEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Amazon Account Id.
     * The unique identifier for the Amazon account.
     */
    @SerializedName(value = "amazonAccountId", alternate = {"AmazonAccountId"})
    @Expose
	@Nullable
    public String amazonAccountId;

    /**
     * The Amazon Resource Id.
     * The Amazon resource identifier (ARN) for the cloud resource.
     */
    @SerializedName(value = "amazonResourceId", alternate = {"AmazonResourceId"})
    @Expose
	@Nullable
    public String amazonResourceId;

    /**
     * The Resource Name.
     * The name of the resource.
     */
    @SerializedName(value = "resourceName", alternate = {"ResourceName"})
    @Expose
	@Nullable
    public String resourceName;

    /**
     * The Resource Type.
     * The type of the resource.
     */
    @SerializedName(value = "resourceType", alternate = {"ResourceType"})
    @Expose
	@Nullable
    public String resourceType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
