// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;

import com.microsoft.graph.security.models.EdiscoverySearch;
import com.microsoft.graph.security.models.AdditionalDataOptions;
import java.util.EnumSet;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Review Set Add To Review Set Parameter Set.
 */
public class EdiscoveryReviewSetAddToReviewSetParameterSet {
    /**
     * The search.
     * 
     */
    @SerializedName(value = "search", alternate = {"Search"})
    @Expose
	@Nullable
    public EdiscoverySearch search;

    /**
     * The additional Data Options.
     * 
     */
    @SerializedName(value = "additionalDataOptions", alternate = {"AdditionalDataOptions"})
    @Expose
	@Nullable
    public EnumSet<AdditionalDataOptions> additionalDataOptions;


    /**
     * Instiaciates a new EdiscoveryReviewSetAddToReviewSetParameterSet
     */
    public EdiscoveryReviewSetAddToReviewSetParameterSet() {}
    /**
     * Instiaciates a new EdiscoveryReviewSetAddToReviewSetParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected EdiscoveryReviewSetAddToReviewSetParameterSet(@Nonnull final EdiscoveryReviewSetAddToReviewSetParameterSetBuilder builder) {
        this.search = builder.search;
        this.additionalDataOptions = builder.additionalDataOptions;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static EdiscoveryReviewSetAddToReviewSetParameterSetBuilder newBuilder() {
        return new EdiscoveryReviewSetAddToReviewSetParameterSetBuilder();
    }
    /**
     * Fluent builder for the EdiscoveryReviewSetAddToReviewSetParameterSet
     */
    public static final class EdiscoveryReviewSetAddToReviewSetParameterSetBuilder {
        /**
         * The search parameter value
         */
        @Nullable
        protected EdiscoverySearch search;
        /**
         * Sets the Search
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public EdiscoveryReviewSetAddToReviewSetParameterSetBuilder withSearch(@Nullable final EdiscoverySearch val) {
            this.search = val;
            return this;
        }
        /**
         * The additionalDataOptions parameter value
         */
        @Nullable
        protected EnumSet<AdditionalDataOptions> additionalDataOptions;
        /**
         * Sets the AdditionalDataOptions
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public EdiscoveryReviewSetAddToReviewSetParameterSetBuilder withAdditionalDataOptions(@Nullable final EnumSet<AdditionalDataOptions> val) {
            this.additionalDataOptions = val;
            return this;
        }
        /**
         * Instanciates a new EdiscoveryReviewSetAddToReviewSetParameterSetBuilder
         */
        @Nullable
        protected EdiscoveryReviewSetAddToReviewSetParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public EdiscoveryReviewSetAddToReviewSetParameterSet build() {
            return new EdiscoveryReviewSetAddToReviewSetParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.search != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("search", search));
        }
        if(this.additionalDataOptions != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("additionalDataOptions", additionalDataOptions));
        }
        return result;
    }
}
