// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.HostPortBanner;
import com.microsoft.graph.security.models.HostPortProtocol;
import com.microsoft.graph.security.models.HostPortComponent;
import com.microsoft.graph.security.models.HostPortStatus;
import com.microsoft.graph.security.models.Host;
import com.microsoft.graph.security.models.SslCertificate;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Port.
 */
public class HostPort extends Entity implements IJsonBackedObject {


    /**
     * The Banners.
     * The hostPortBanners retrieved from scanning the port.
     */
    @SerializedName(value = "banners", alternate = {"Banners"})
    @Expose
	@Nullable
    public java.util.List<HostPortBanner> banners;

    /**
     * The First Seen Date Time.
     * The first date and time when Microsoft Defender Threat Intelligence observed the hostPort. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014, is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "firstSeenDateTime", alternate = {"FirstSeenDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime firstSeenDateTime;

    /**
     * The Last Scan Date Time.
     * The last date and time when Microsoft Defender Threat Intelligence scanned the hostPort. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014, is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "lastScanDateTime", alternate = {"LastScanDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastScanDateTime;

    /**
     * The Last Seen Date Time.
     * The last date and time when Microsoft Defender Threat Intelligence observed the hostPort. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014, is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "lastSeenDateTime", alternate = {"LastSeenDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastSeenDateTime;

    /**
     * The Port.
     * The numerical identifier of the port which is standardized across the internet.
     */
    @SerializedName(value = "port", alternate = {"Port"})
    @Expose
	@Nullable
    public Integer port;

    /**
     * The Protocol.
     * The general protocol used to scan the port. The possible values are: tcp, udp, unknownFutureValue.
     */
    @SerializedName(value = "protocol", alternate = {"Protocol"})
    @Expose
	@Nullable
    public HostPortProtocol protocol;

    /**
     * The Services.
     * The hostPortComponents retrieved from scanning the port.
     */
    @SerializedName(value = "services", alternate = {"Services"})
    @Expose
	@Nullable
    public java.util.List<HostPortComponent> services;

    /**
     * The Status.
     * The status of the port. The possible values are: open, filtered, closed, unknownFutureValue.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public HostPortStatus status;

    /**
     * The Times Observed.
     * The total amount of times that Microsoft Defender Threat Intelligence has observed the hostPort in all its scans.
     */
    @SerializedName(value = "timesObserved", alternate = {"TimesObserved"})
    @Expose
	@Nullable
    public Integer timesObserved;

    /**
     * The Host.
     * The host related to this hostPort. This is a reverse navigation property. When you navigate to hostPorts from a host, assume that this is a return reference.
     */
    @SerializedName(value = "host", alternate = {"Host"})
    @Expose
	@Nullable
    public Host host;

    /**
     * The Most Recent Ssl Certificate.
     * The most recent sslCertificate used to communicate on the port.
     */
    @SerializedName(value = "mostRecentSslCertificate", alternate = {"MostRecentSslCertificate"})
    @Expose
	@Nullable
    public SslCertificate mostRecentSslCertificate;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
