// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.AutonomousSystem;
import com.microsoft.graph.security.models.Host;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ip Address.
 */
public class IpAddress extends Host implements IJsonBackedObject {


    /**
     * The Autonomous System.
     * The details about the autonomous system to which this IP address belongs.
     */
    @SerializedName(value = "autonomousSystem", alternate = {"AutonomousSystem"})
    @Expose
	@Nullable
    public AutonomousSystem autonomousSystem;

    /**
     * The Country Or Region.
     * The country/region for this IP address.
     */
    @SerializedName(value = "countryOrRegion", alternate = {"CountryOrRegion"})
    @Expose
	@Nullable
    public String countryOrRegion;

    /**
     * The Hosting Provider.
     * The hosting company listed for this host.
     */
    @SerializedName(value = "hostingProvider", alternate = {"HostingProvider"})
    @Expose
	@Nullable
    public String hostingProvider;

    /**
     * The Netblock.
     * The block of IP addresses this IP address belongs to.
     */
    @SerializedName(value = "netblock", alternate = {"Netblock"})
    @Expose
	@Nullable
    public String netblock;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
