// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;
import com.microsoft.graph.security.requests.EdiscoveryCustodianUpdateIndexRequest;
import com.microsoft.graph.security.models.EdiscoveryCustodian;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Custodian Update Index Request Builder.
 */
public class EdiscoveryCustodianUpdateIndexRequestBuilder extends BaseActionRequestBuilder<EdiscoveryCustodian> {

    /**
     * The request builder for this EdiscoveryCustodianUpdateIndex
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryCustodianUpdateIndexRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the EdiscoveryCustodianUpdateIndexRequest
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryCustodianUpdateIndexRequest instance
     */
    @Nonnull
    public EdiscoveryCustodianUpdateIndexRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the EdiscoveryCustodianUpdateIndexRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryCustodianUpdateIndexRequest instance
     */
    @Nonnull
    public EdiscoveryCustodianUpdateIndexRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final EdiscoveryCustodianUpdateIndexRequest request = new EdiscoveryCustodianUpdateIndexRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
