// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.ThreatIntelligence;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Threat Intelligence Request Builder.
 */
public class ThreatIntelligenceRequestBuilder extends BaseRequestBuilder<ThreatIntelligence> {

    /**
     * The request builder for the ThreatIntelligence
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ThreatIntelligenceRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ThreatIntelligenceRequest instance
     */
    @Nonnull
    public ThreatIntelligenceRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the ThreatIntelligenceRequest instance
     */
    @Nonnull
    public ThreatIntelligenceRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.security.requests.ThreatIntelligenceRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the ArticleIndicator collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.ArticleIndicatorCollectionRequestBuilder articleIndicators() {
        return new com.microsoft.graph.security.requests.ArticleIndicatorCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("articleIndicators"), getClient(), null);
    }

    /**
     * Gets a request builder for the ArticleIndicator item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.ArticleIndicatorRequestBuilder articleIndicators(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.ArticleIndicatorRequestBuilder(getRequestUrlWithAdditionalSegment("articleIndicators") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Article collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.ArticleCollectionRequestBuilder articles() {
        return new com.microsoft.graph.security.requests.ArticleCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("articles"), getClient(), null);
    }

    /**
     * Gets a request builder for the Article item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.ArticleRequestBuilder articles(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.ArticleRequestBuilder(getRequestUrlWithAdditionalSegment("articles") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the HostComponent collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostComponentCollectionRequestBuilder hostComponents() {
        return new com.microsoft.graph.security.requests.HostComponentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("hostComponents"), getClient(), null);
    }

    /**
     * Gets a request builder for the HostComponent item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostComponentRequestBuilder hostComponents(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostComponentRequestBuilder(getRequestUrlWithAdditionalSegment("hostComponents") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the HostCookie collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostCookieCollectionRequestBuilder hostCookies() {
        return new com.microsoft.graph.security.requests.HostCookieCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("hostCookies"), getClient(), null);
    }

    /**
     * Gets a request builder for the HostCookie item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostCookieRequestBuilder hostCookies(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostCookieRequestBuilder(getRequestUrlWithAdditionalSegment("hostCookies") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the HostPair collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostPairCollectionRequestBuilder hostPairs() {
        return new com.microsoft.graph.security.requests.HostPairCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("hostPairs"), getClient(), null);
    }

    /**
     * Gets a request builder for the HostPair item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostPairRequestBuilder hostPairs(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostPairRequestBuilder(getRequestUrlWithAdditionalSegment("hostPairs") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the HostPort collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostPortCollectionRequestBuilder hostPorts() {
        return new com.microsoft.graph.security.requests.HostPortCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("hostPorts"), getClient(), null);
    }

    /**
     * Gets a request builder for the HostPort item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostPortRequestBuilder hostPorts(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostPortRequestBuilder(getRequestUrlWithAdditionalSegment("hostPorts") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Host collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostCollectionRequestBuilder hosts() {
        return new com.microsoft.graph.security.requests.HostCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("hosts"), getClient(), null);
    }

    /**
     * Gets a request builder for the Host item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostRequestBuilder hosts(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostRequestBuilder(getRequestUrlWithAdditionalSegment("hosts") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the HostSslCertificate collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostSslCertificateCollectionRequestBuilder hostSslCertificates() {
        return new com.microsoft.graph.security.requests.HostSslCertificateCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("hostSslCertificates"), getClient(), null);
    }

    /**
     * Gets a request builder for the HostSslCertificate item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostSslCertificateRequestBuilder hostSslCertificates(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostSslCertificateRequestBuilder(getRequestUrlWithAdditionalSegment("hostSslCertificates") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the HostTracker collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostTrackerCollectionRequestBuilder hostTrackers() {
        return new com.microsoft.graph.security.requests.HostTrackerCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("hostTrackers"), getClient(), null);
    }

    /**
     * Gets a request builder for the HostTracker item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostTrackerRequestBuilder hostTrackers(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostTrackerRequestBuilder(getRequestUrlWithAdditionalSegment("hostTrackers") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the IntelligenceProfileIndicator collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.IntelligenceProfileIndicatorCollectionRequestBuilder intelligenceProfileIndicators() {
        return new com.microsoft.graph.security.requests.IntelligenceProfileIndicatorCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("intelligenceProfileIndicators"), getClient(), null);
    }

    /**
     * Gets a request builder for the IntelligenceProfileIndicator item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.IntelligenceProfileIndicatorRequestBuilder intelligenceProfileIndicators(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.IntelligenceProfileIndicatorRequestBuilder(getRequestUrlWithAdditionalSegment("intelligenceProfileIndicators") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the IntelligenceProfile collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.IntelligenceProfileCollectionRequestBuilder intelProfiles() {
        return new com.microsoft.graph.security.requests.IntelligenceProfileCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("intelProfiles"), getClient(), null);
    }

    /**
     * Gets a request builder for the IntelligenceProfile item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.IntelligenceProfileRequestBuilder intelProfiles(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.IntelligenceProfileRequestBuilder(getRequestUrlWithAdditionalSegment("intelProfiles") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PassiveDnsRecord collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.PassiveDnsRecordCollectionRequestBuilder passiveDnsRecords() {
        return new com.microsoft.graph.security.requests.PassiveDnsRecordCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("passiveDnsRecords"), getClient(), null);
    }

    /**
     * Gets a request builder for the PassiveDnsRecord item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.PassiveDnsRecordRequestBuilder passiveDnsRecords(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.PassiveDnsRecordRequestBuilder(getRequestUrlWithAdditionalSegment("passiveDnsRecords") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the SslCertificate collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.SslCertificateCollectionRequestBuilder sslCertificates() {
        return new com.microsoft.graph.security.requests.SslCertificateCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("sslCertificates"), getClient(), null);
    }

    /**
     * Gets a request builder for the SslCertificate item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.SslCertificateRequestBuilder sslCertificates(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.SslCertificateRequestBuilder(getRequestUrlWithAdditionalSegment("sslCertificates") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Subdomain collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.SubdomainCollectionRequestBuilder subdomains() {
        return new com.microsoft.graph.security.requests.SubdomainCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("subdomains"), getClient(), null);
    }

    /**
     * Gets a request builder for the Subdomain item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.SubdomainRequestBuilder subdomains(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.SubdomainRequestBuilder(getRequestUrlWithAdditionalSegment("subdomains") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Vulnerability collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.VulnerabilityCollectionRequestBuilder vulnerabilities() {
        return new com.microsoft.graph.security.requests.VulnerabilityCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("vulnerabilities"), getClient(), null);
    }

    /**
     * Gets a request builder for the Vulnerability item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.VulnerabilityRequestBuilder vulnerabilities(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.VulnerabilityRequestBuilder(getRequestUrlWithAdditionalSegment("vulnerabilities") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the WhoisHistoryRecord collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.WhoisHistoryRecordCollectionRequestBuilder whoisHistoryRecords() {
        return new com.microsoft.graph.security.requests.WhoisHistoryRecordCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("whoisHistoryRecords"), getClient(), null);
    }

    /**
     * Gets a request builder for the WhoisHistoryRecord item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.WhoisHistoryRecordRequestBuilder whoisHistoryRecords(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.WhoisHistoryRecordRequestBuilder(getRequestUrlWithAdditionalSegment("whoisHistoryRecords") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the WhoisRecord collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.WhoisRecordCollectionRequestBuilder whoisRecords() {
        return new com.microsoft.graph.security.requests.WhoisRecordCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("whoisRecords"), getClient(), null);
    }

    /**
     * Gets a request builder for the WhoisRecord item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.WhoisRecordRequestBuilder whoisRecords(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.WhoisRecordRequestBuilder(getRequestUrlWithAdditionalSegment("whoisRecords") + "/" + id, getClient(), null);
    }
}
