// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.WhoisBaseRecord;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Whois Base Record Request.
 */
public class WhoisBaseRecordRequest extends BaseRequest<WhoisBaseRecord> {
	
    /**
     * The request for the WhoisBaseRecord
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public WhoisBaseRecordRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends WhoisBaseRecord> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the WhoisBaseRecord
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WhoisBaseRecordRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WhoisBaseRecord.class);
    }

    /**
     * Gets the WhoisBaseRecord from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WhoisBaseRecord> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WhoisBaseRecord from the service
     *
     * @return the WhoisBaseRecord from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WhoisBaseRecord get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WhoisBaseRecord> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WhoisBaseRecord delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WhoisBaseRecord with a source
     *
     * @param sourceWhoisBaseRecord the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WhoisBaseRecord> patchAsync(@Nonnull final WhoisBaseRecord sourceWhoisBaseRecord) {
        return sendAsync(HttpMethod.PATCH, sourceWhoisBaseRecord);
    }

    /**
     * Patches this WhoisBaseRecord with a source
     *
     * @param sourceWhoisBaseRecord the source object with updates
     * @return the updated WhoisBaseRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WhoisBaseRecord patch(@Nonnull final WhoisBaseRecord sourceWhoisBaseRecord) throws ClientException {
        return send(HttpMethod.PATCH, sourceWhoisBaseRecord);
    }

    /**
     * Creates a WhoisBaseRecord with a new object
     *
     * @param newWhoisBaseRecord the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WhoisBaseRecord> postAsync(@Nonnull final WhoisBaseRecord newWhoisBaseRecord) {
        return sendAsync(HttpMethod.POST, newWhoisBaseRecord);
    }

    /**
     * Creates a WhoisBaseRecord with a new object
     *
     * @param newWhoisBaseRecord the new object to create
     * @return the created WhoisBaseRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WhoisBaseRecord post(@Nonnull final WhoisBaseRecord newWhoisBaseRecord) throws ClientException {
        return send(HttpMethod.POST, newWhoisBaseRecord);
    }

    /**
     * Creates a WhoisBaseRecord with a new object
     *
     * @param newWhoisBaseRecord the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WhoisBaseRecord> putAsync(@Nonnull final WhoisBaseRecord newWhoisBaseRecord) {
        return sendAsync(HttpMethod.PUT, newWhoisBaseRecord);
    }

    /**
     * Creates a WhoisBaseRecord with a new object
     *
     * @param newWhoisBaseRecord the object to create/update
     * @return the created WhoisBaseRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WhoisBaseRecord put(@Nonnull final WhoisBaseRecord newWhoisBaseRecord) throws ClientException {
        return send(HttpMethod.PUT, newWhoisBaseRecord);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WhoisBaseRecordRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WhoisBaseRecordRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

