/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.callrecords.requests;

import com.microsoft.graph.callrecords.models.Session;
import com.microsoft.graph.callrecords.requests.SessionCollectionPage;
import com.microsoft.graph.callrecords.requests.SessionCollectionRequestBuilder;
import com.microsoft.graph.callrecords.requests.SessionCollectionResponse;
import com.microsoft.graph.callrecords.requests.SessionRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SessionCollectionRequest
extends BaseEntityCollectionRequest<Session, SessionCollectionResponse, SessionCollectionPage> {
    public SessionCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SessionCollectionResponse.class, SessionCollectionPage.class, SessionCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Session> postAsync(@Nonnull Session newSession) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SessionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newSession);
    }

    @Nonnull
    public Session post(@Nonnull Session newSession) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SessionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSession);
    }

    @Nonnull
    public SessionCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public SessionCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public SessionCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public SessionCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SessionCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public SessionCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public SessionCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public SessionCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public SessionCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

