/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.identitygovernance.models.CustomTaskExtension;
import com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionCollectionPage;
import com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionCollectionResponse;
import com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomTaskExtensionCollectionRequest
extends BaseEntityCollectionRequest<CustomTaskExtension, CustomTaskExtensionCollectionResponse, CustomTaskExtensionCollectionPage> {
    public CustomTaskExtensionCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CustomTaskExtensionCollectionResponse.class, CustomTaskExtensionCollectionPage.class, CustomTaskExtensionCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<CustomTaskExtension> postAsync(@Nonnull CustomTaskExtension newCustomTaskExtension) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CustomTaskExtensionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newCustomTaskExtension);
    }

    @Nonnull
    public CustomTaskExtension post(@Nonnull CustomTaskExtension newCustomTaskExtension) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CustomTaskExtensionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCustomTaskExtension);
    }

    @Nonnull
    public CustomTaskExtensionCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CustomTaskExtensionCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public CustomTaskExtensionCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public CustomTaskExtensionCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public CustomTaskExtensionCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public CustomTaskExtensionCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public CustomTaskExtensionCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public CustomTaskExtensionCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public CustomTaskExtensionCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

