/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.MessageRule;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MessageRuleRequest
extends BaseRequest<MessageRule> {
    public MessageRuleRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MessageRule.class);
    }

    @Nonnull
    public CompletableFuture<MessageRule> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public MessageRule get() throws ClientException {
        return (MessageRule)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<MessageRule> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public MessageRule delete() throws ClientException {
        return (MessageRule)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<MessageRule> patchAsync(@Nonnull MessageRule sourceMessageRule) {
        return this.sendAsync(HttpMethod.PATCH, sourceMessageRule);
    }

    @Nullable
    public MessageRule patch(@Nonnull MessageRule sourceMessageRule) throws ClientException {
        return (MessageRule)this.send(HttpMethod.PATCH, sourceMessageRule);
    }

    @Nonnull
    public CompletableFuture<MessageRule> postAsync(@Nonnull MessageRule newMessageRule) {
        return this.sendAsync(HttpMethod.POST, newMessageRule);
    }

    @Nullable
    public MessageRule post(@Nonnull MessageRule newMessageRule) throws ClientException {
        return (MessageRule)this.send(HttpMethod.POST, newMessageRule);
    }

    @Nonnull
    public CompletableFuture<MessageRule> putAsync(@Nonnull MessageRule newMessageRule) {
        return this.sendAsync(HttpMethod.PUT, newMessageRule);
    }

    @Nullable
    public MessageRule put(@Nonnull MessageRule newMessageRule) throws ClientException {
        return (MessageRule)this.send(HttpMethod.PUT, newMessageRule);
    }

    @Nonnull
    public MessageRuleRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public MessageRuleRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

