/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Trending;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.TrendingCollectionPage;
import com.microsoft.graph.requests.TrendingCollectionRequestBuilder;
import com.microsoft.graph.requests.TrendingCollectionResponse;
import com.microsoft.graph.requests.TrendingRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TrendingCollectionRequest
extends BaseEntityCollectionRequest<Trending, TrendingCollectionResponse, TrendingCollectionPage> {
    public TrendingCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TrendingCollectionResponse.class, TrendingCollectionPage.class, TrendingCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Trending> postAsync(@Nonnull Trending newTrending) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TrendingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newTrending);
    }

    @Nonnull
    public Trending post(@Nonnull Trending newTrending) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TrendingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTrending);
    }

    @Nonnull
    public TrendingCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public TrendingCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public TrendingCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public TrendingCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public TrendingCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public TrendingCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public TrendingCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public TrendingCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public TrendingCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

