/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http;

import com.microsoft.kiota.ApiClientBuilder;
import com.microsoft.kiota.ApiException;
import com.microsoft.kiota.ApiExceptionBuilder;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.RequestOption;
import com.microsoft.kiota.ResponseHandler;
import com.microsoft.kiota.ResponseHandlerOption;
import com.microsoft.kiota.ResponseHeaders;
import com.microsoft.kiota.authentication.AuthenticationProvider;
import com.microsoft.kiota.http.ContinuousAccessEvaluationClaims;
import com.microsoft.kiota.http.HeadersCompatibility;
import com.microsoft.kiota.http.KiotaClientFactory;
import com.microsoft.kiota.http.ObservabilityOptions;
import com.microsoft.kiota.http.TelemetrySemanticConventions;
import com.microsoft.kiota.http.middleware.ParametersNameDecodingHandler;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ParseNodeFactory;
import com.microsoft.kiota.serialization.ParseNodeFactoryRegistry;
import com.microsoft.kiota.serialization.SerializationWriterFactory;
import com.microsoft.kiota.serialization.SerializationWriterFactoryRegistry;
import com.microsoft.kiota.serialization.ValuedEnumParser;
import com.microsoft.kiota.store.BackingStoreFactory;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;

public class OkHttpRequestAdapter
implements RequestAdapter {
    private static final String CONTENT_LENGTH_HEADER_KEY = "Content-Length";
    private static final String CONTENT_TYPE_HEADER_KEY = "Content-Type";
    @Nonnull
    private final Call.Factory client;
    @Nonnull
    private final AuthenticationProvider authProvider;
    @Nonnull
    private final ObservabilityOptions obsOptions;
    @Nonnull
    private ParseNodeFactory pNodeFactory;
    @Nonnull
    private SerializationWriterFactory sWriterFactory;
    @Nonnull
    private String baseUrl = "";
    private static final String nullRequestInfoParameter = "parameter requestInfo cannot be null";
    private static final String nullEnumParserParameter = "parameter enumParser cannot be null";
    private static final String nullFactoryParameter = "parameter factory cannot be null";
    private static final Pattern queryParametersCleanupPattern = Pattern.compile("\\{\\?[^\\}]+\\}", 2);
    private final char[] queryParametersToDecodeForTracing = new char[]{'-', '.', '~', '$'};
    @Nonnull
    public static final String eventResponseHandlerInvokedKey = "com.microsoft.kiota.response_handler_invoked";
    @Nonnull
    public static final String errorMappingFoundAttributeName = "com.microsoft.kiota.error_mapping_found";
    @Nonnull
    public static final String errorBodyFoundAttributeName = "com.microsoft.kiota.error_body_found";
    private static final String claimsKey = "claims";
    @Nonnull
    public static final String authenticateChallengedEventKey = "com.microsoft.kiota.authenticate_challenge_received";

    public void setBaseUrl(@Nonnull String baseUrl) {
        this.baseUrl = Objects.requireNonNull(baseUrl);
    }

    @Nonnull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public OkHttpRequestAdapter(@Nonnull AuthenticationProvider authenticationProvider) {
        this(authenticationProvider, null, null, null, null);
    }

    public OkHttpRequestAdapter(@Nonnull AuthenticationProvider authenticationProvider, @Nullable ParseNodeFactory parseNodeFactory) {
        this(authenticationProvider, parseNodeFactory, null, null, null);
    }

    public OkHttpRequestAdapter(@Nonnull AuthenticationProvider authenticationProvider, @Nullable ParseNodeFactory parseNodeFactory, @Nullable SerializationWriterFactory serializationWriterFactory) {
        this(authenticationProvider, parseNodeFactory, serializationWriterFactory, null, null);
    }

    public OkHttpRequestAdapter(@Nonnull AuthenticationProvider authenticationProvider, @Nullable ParseNodeFactory parseNodeFactory, @Nullable SerializationWriterFactory serializationWriterFactory, @Nullable Call.Factory client) {
        this(authenticationProvider, parseNodeFactory, serializationWriterFactory, client, null);
    }

    public OkHttpRequestAdapter(@Nonnull AuthenticationProvider authenticationProvider, @Nullable ParseNodeFactory parseNodeFactory, @Nullable SerializationWriterFactory serializationWriterFactory, @Nullable Call.Factory client, @Nullable ObservabilityOptions observabilityOptions) {
        this.authProvider = Objects.requireNonNull(authenticationProvider, "parameter authenticationProvider cannot be null");
        this.client = client == null ? KiotaClientFactory.create().build() : client;
        this.pNodeFactory = parseNodeFactory == null ? ParseNodeFactoryRegistry.defaultInstance : parseNodeFactory;
        this.sWriterFactory = serializationWriterFactory == null ? SerializationWriterFactoryRegistry.defaultInstance : serializationWriterFactory;
        this.obsOptions = observabilityOptions == null ? new ObservabilityOptions() : observabilityOptions;
    }

    @Nonnull
    public SerializationWriterFactory getSerializationWriterFactory() {
        return this.sWriterFactory;
    }

    public void enableBackingStore(@Nullable BackingStoreFactory backingStoreFactory) {
        this.pNodeFactory = Objects.requireNonNull(ApiClientBuilder.enableBackingStoreForParseNodeFactory((ParseNodeFactory)this.pNodeFactory));
        this.sWriterFactory = Objects.requireNonNull(ApiClientBuilder.enableBackingStoreForSerializationWriterFactory((SerializationWriterFactory)this.sWriterFactory));
        if (backingStoreFactory != null) {
            BackingStoreFactorySingleton.instance = backingStoreFactory;
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public <ModelType extends Parsable> List<ModelType> sendCollection(@Nonnull RequestInformation requestInfo, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings, @Nonnull ParsableFactory<ModelType> factory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ResponseHandler getResponseHandler(RequestInformation requestInfo) {
        Collection requestOptions = requestInfo.getRequestOptions();
        for (RequestOption rOption : requestOptions) {
            if (!(rOption instanceof ResponseHandlerOption)) continue;
            ResponseHandlerOption option = (ResponseHandlerOption)rOption;
            return option.getResponseHandler();
        }
        return null;
    }

    private Span startSpan(@Nonnull RequestInformation requestInfo, @Nonnull String methodName) {
        String decodedUriTemplate = ParametersNameDecodingHandler.decodeQueryParameters(requestInfo.urlTemplate, this.queryParametersToDecodeForTracing);
        String cleanedUriTemplate = queryParametersCleanupPattern.matcher(decodedUriTemplate).replaceAll("");
        Span span = GlobalOpenTelemetry.getTracer((String)this.obsOptions.getTracerInstrumentationName()).spanBuilder(methodName + " - " + cleanedUriTemplate).startSpan();
        span.setAttribute(TelemetrySemanticConventions.URL_TEMPLATE, (Object)decodedUriTemplate);
        return span;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public <ModelType extends Parsable> ModelType send(@Nonnull RequestInformation requestInfo, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings, @Nonnull ParsableFactory<ModelType> factory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setResponseType(Object result, Span span) {
        if (result != null) {
            span.setAttribute("com.microsoft.kiota.response.type", result.getClass().getName());
        }
    }

    private void closeResponse(boolean closeResponse, Response response) {
        if (closeResponse && response.code() != 204) {
            response.close();
        }
    }

    @Nonnull
    private String getMediaTypeAndSubType(@Nonnull MediaType mediaType) {
        return mediaType.type() + "/" + mediaType.subtype();
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public <ModelType> ModelType sendPrimitive(@Nonnull RequestInformation requestInfo, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings, @Nonnull Class<ModelType> targetClass) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public <ModelType extends Enum<ModelType>> ModelType sendEnum(@Nonnull RequestInformation requestInfo, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings, @Nonnull ValuedEnumParser<ModelType> enumParser) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public <ModelType extends Enum<ModelType>> List<ModelType> sendEnumCollection(@Nonnull RequestInformation requestInfo, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings, @Nonnull ValuedEnumParser<ModelType> enumParser) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public <ModelType> List<ModelType> sendPrimitiveCollection(@Nonnull RequestInformation requestInfo, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings, @Nonnull Class<ModelType> targetClass) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private ParseNode getRootParseNode(Response response, Span parentSpan, Span spanForAttributes) {
        Span span = GlobalOpenTelemetry.getTracer((String)this.obsOptions.getTracerInstrumentationName()).spanBuilder("getRootParseNode").setParent(Context.current().with((ImplicitContextKeyed)parentSpan)).startSpan();
        try {
            ParseNode parseNode;
            block17: {
                MediaType contentType;
                InputStream rawInputStream;
                Scope scope;
                block15: {
                    ParseNode parseNode2;
                    block16: {
                        ResponseBody body;
                        block13: {
                            ParseNode parseNode3;
                            block14: {
                                scope = span.makeCurrent();
                                try {
                                    body = response.body();
                                    if (body != null) break block13;
                                    parseNode3 = null;
                                    if (scope == null) break block14;
                                }
                                catch (Throwable throwable) {
                                    if (scope != null) {
                                        try {
                                            scope.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                scope.close();
                            }
                            return parseNode3;
                        }
                        rawInputStream = body.byteStream();
                        contentType = body.contentType();
                        if (contentType != null) break block15;
                        parseNode2 = null;
                        if (scope == null) break block16;
                        scope.close();
                    }
                    return parseNode2;
                }
                parseNode = this.pNodeFactory.getParseNode(this.getMediaTypeAndSubType(contentType), rawInputStream);
                if (scope == null) break block17;
                scope.close();
            }
            return parseNode;
        }
        finally {
            span.end();
        }
    }

    private boolean shouldReturnNull(Response response) {
        int statusCode = response.code();
        return statusCode == 204;
    }

    private Response throwIfFailedResponse(@Nonnull Response response, @Nonnull Span spanForAttributes, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings) {
        Span span = GlobalOpenTelemetry.getTracer((String)this.obsOptions.getTracerInstrumentationName()).spanBuilder("throwIfFailedResponse").setParent(Context.current().with((ImplicitContextKeyed)spanForAttributes)).startSpan();
        try (Scope scope = span.makeCurrent();){
            if (response.isSuccessful()) {
                Response response2 = response;
                return response2;
            }
            spanForAttributes.setStatus(StatusCode.ERROR);
            String statusCodeAsString = Integer.toString(response.code());
            int statusCode = response.code();
            ResponseHeaders responseHeaders = HeadersCompatibility.getResponseHeaders(response.headers());
            if (!(errorMappings != null && (errorMappings.containsKey(statusCodeAsString) || statusCode >= 400 && statusCode < 500 && errorMappings.containsKey("4XX") || statusCode >= 500 && statusCode < 600 && errorMappings.containsKey("5XX") || errorMappings.containsKey("XXX")))) {
                spanForAttributes.setAttribute(errorMappingFoundAttributeName, false);
                ApiException result = new ApiExceptionBuilder().withMessage("the server returned an unexpected status code and no error class is registered for this code " + statusCode).withResponseStatusCode(statusCode).withResponseHeaders(responseHeaders).build();
                spanForAttributes.recordException((Throwable)result);
                throw result;
            }
            spanForAttributes.setAttribute(errorMappingFoundAttributeName, true);
            ParsableFactory<? extends Parsable> errorClass = errorMappings.containsKey(statusCodeAsString) ? errorMappings.get(statusCodeAsString) : (statusCode >= 400 && statusCode < 500 ? errorMappings.getOrDefault("4XX", errorMappings.get("XXX")) : errorMappings.getOrDefault("5XX", errorMappings.get("XXX")));
            boolean closeResponse = true;
            try {
                ParseNode rootNode = this.getRootParseNode(response, span, span);
                if (rootNode == null) {
                    spanForAttributes.setAttribute(errorBodyFoundAttributeName, false);
                    closeResponse = false;
                    ApiException result = new ApiExceptionBuilder().withMessage("service returned status code" + statusCode + " but no response body was found").withResponseStatusCode(statusCode).withResponseHeaders(responseHeaders).build();
                    spanForAttributes.recordException((Throwable)result);
                    throw result;
                }
                spanForAttributes.setAttribute(errorBodyFoundAttributeName, true);
                Span deserializationSpan = GlobalOpenTelemetry.getTracer((String)this.obsOptions.getTracerInstrumentationName()).spanBuilder("getObjectValue").setParent(Context.current().with((ImplicitContextKeyed)span)).startSpan();
                try {
                    Scope deserializationScope = deserializationSpan.makeCurrent();
                    try {
                        ApiException result = new ApiExceptionBuilder(() -> rootNode.getObjectValue(errorClass)).withResponseStatusCode(statusCode).withResponseHeaders(responseHeaders).build();
                        spanForAttributes.recordException((Throwable)result);
                        throw result;
                    }
                    catch (Throwable throwable) {
                        if (deserializationScope != null) {
                            try {
                                deserializationScope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    deserializationSpan.end();
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                this.closeResponse(closeResponse, response);
                throw throwable;
            }
        }
        finally {
            span.end();
        }
    }

    private Response getHttpResponseMessage(@Nonnull RequestInformation requestInfo, @Nonnull Span parentSpan, @Nonnull Span spanForAttributes, @Nullable String claims) {
        Objects.requireNonNull(requestInfo, nullRequestInfoParameter);
        Span span = GlobalOpenTelemetry.getTracer((String)this.obsOptions.getTracerInstrumentationName()).spanBuilder("getHttpResponseMessage").setParent(Context.current().with((ImplicitContextKeyed)parentSpan)).startSpan();
        try {
            Response response;
            block14: {
                Scope scope = span.makeCurrent();
                try {
                    String contentTypeHeaderValue;
                    this.setBaseUrlForRequestInformation(requestInfo);
                    HashMap<String, Object> additionalContext = new HashMap<String, Object>();
                    additionalContext.put("parent-span", span);
                    if (claims != null && !claims.isEmpty()) {
                        additionalContext.put(claimsKey, claims);
                    }
                    this.authProvider.authenticateRequest(requestInfo, additionalContext);
                    Response response2 = this.client.newCall(this.getRequestFromRequestInformation(requestInfo, span, spanForAttributes)).execute();
                    String contentLengthHeaderValue = this.getHeaderValue(response2, CONTENT_LENGTH_HEADER_KEY);
                    if (contentLengthHeaderValue != null && !contentLengthHeaderValue.isEmpty()) {
                        long contentLengthHeaderValueAsLong = Long.parseLong(contentLengthHeaderValue);
                        spanForAttributes.setAttribute(TelemetrySemanticConventions.EXPERIMENTAL_HTTP_RESPONSE_BODY_SIZE, (Object)contentLengthHeaderValueAsLong);
                    }
                    if ((contentTypeHeaderValue = this.getHeaderValue(response2, CONTENT_TYPE_HEADER_KEY)) != null && !contentTypeHeaderValue.isEmpty()) {
                        spanForAttributes.setAttribute(TelemetrySemanticConventions.HTTP_RESPONSE_HEADER_CONTENT_TYPE, (Object)contentTypeHeaderValue);
                    }
                    spanForAttributes.setAttribute(TelemetrySemanticConventions.HTTP_RESPONSE_STATUS_CODE, response2.code());
                    spanForAttributes.setAttribute(TelemetrySemanticConventions.NETWORK_PROTOCOL_NAME, (Object)response2.protocol().toString().toUpperCase(Locale.ROOT));
                    response = this.retryCAEResponseIfRequired(response2, requestInfo, span, spanForAttributes, claims);
                    if (scope == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | URISyntaxException ex) {
                        spanForAttributes.recordException((Throwable)ex);
                        throw new RuntimeException(ex);
                    }
                }
                scope.close();
            }
            return response;
        }
        finally {
            span.end();
        }
    }

    private String getHeaderValue(Response response, String key) {
        String firstEntryValue;
        List headerValue = response.headers().values(key);
        if (headerValue != null && headerValue.size() > 0 && (firstEntryValue = (String)headerValue.get(0)) != null && !firstEntryValue.isEmpty()) {
            return firstEntryValue;
        }
        return null;
    }

    private Response retryCAEResponseIfRequired(@Nonnull Response response, @Nonnull RequestInformation requestInfo, @Nonnull Span parentSpan, @Nonnull Span spanForAttributes, @Nullable String claims) {
        Span span = GlobalOpenTelemetry.getTracer((String)this.obsOptions.getTracerInstrumentationName()).spanBuilder("retryCAEResponseIfRequired").setParent(Context.current().with((ImplicitContextKeyed)parentSpan)).startSpan();
        try {
            Response response2;
            block16: {
                Scope scope;
                block14: {
                    Response response3;
                    block15: {
                        scope = span.makeCurrent();
                        try {
                            String responseClaims = this.getClaimsFromResponse(response, requestInfo, claims);
                            if (responseClaims == null || responseClaims.isEmpty()) break block14;
                            if (requestInfo.content != null && requestInfo.content.markSupported()) {
                                try {
                                    requestInfo.content.reset();
                                }
                                catch (IOException ex) {
                                    spanForAttributes.recordException((Throwable)ex);
                                    throw new RuntimeException(ex);
                                }
                            }
                            this.closeResponse(true, response);
                            span.addEvent(authenticateChallengedEventKey);
                            spanForAttributes.setAttribute(TelemetrySemanticConventions.HTTP_REQUEST_RESEND_COUNT, 1);
                            response3 = this.getHttpResponseMessage(requestInfo, span, spanForAttributes, responseClaims);
                            if (scope == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        scope.close();
                    }
                    return response3;
                }
                response2 = response;
                if (scope == null) break block16;
                scope.close();
            }
            return response2;
        }
        finally {
            span.end();
        }
    }

    String getClaimsFromResponse(@Nonnull Response response, @Nonnull RequestInformation requestInfo, @Nullable String claims) {
        if (response.code() == 401 && (claims == null || claims.isEmpty()) && (requestInfo.content == null || requestInfo.content.markSupported())) {
            return ContinuousAccessEvaluationClaims.getClaimsFromResponse(response);
        }
        return null;
    }

    private void setBaseUrlForRequestInformation(@Nonnull RequestInformation requestInfo) {
        Objects.requireNonNull(requestInfo);
        requestInfo.pathParameters.put("baseurl", this.getBaseUrl());
    }

    @Nonnull
    public <T> T convertToNativeRequest(@Nonnull RequestInformation requestInfo) {
        Objects.requireNonNull(requestInfo, nullRequestInfoParameter);
        Span span = this.startSpan(requestInfo, "convertToNativeRequest");
        try {
            Request request;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    this.authProvider.authenticateRequest(requestInfo, null);
                    request = this.getRequestFromRequestInformation(requestInfo, span, span);
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | URISyntaxException ex) {
                        span.recordException((Throwable)ex);
                        throw new RuntimeException(ex);
                    }
                }
                scope.close();
            }
            return (T)request;
        }
        finally {
            span.end();
        }
    }

    @Nonnull
    protected Request getRequestFromRequestInformation(final @Nonnull RequestInformation requestInfo, @Nonnull Span parentSpan, final @Nonnull Span spanForAttributes) throws URISyntaxException, IOException {
        Span span = GlobalOpenTelemetry.getTracer((String)this.obsOptions.getTracerInstrumentationName()).spanBuilder("getRequestFromRequestInformation").setParent(Context.current().with((ImplicitContextKeyed)parentSpan)).startSpan();
        try {
            Request request;
            block17: {
                Scope scope = span.makeCurrent();
                try {
                    long contentLength;
                    RequestBody requestBody;
                    RequestBody body;
                    spanForAttributes.setAttribute(TelemetrySemanticConventions.HTTP_REQUEST_METHOD, (Object)requestInfo.httpMethod.toString());
                    URL requestURL = requestInfo.getUri().toURL();
                    if (this.obsOptions.getIncludeEUIIAttributes()) {
                        spanForAttributes.setAttribute(TelemetrySemanticConventions.URL_FULL, (Object)requestURL.toString());
                    }
                    spanForAttributes.setAttribute(TelemetrySemanticConventions.SERVER_PORT, requestURL.getPort());
                    spanForAttributes.setAttribute(TelemetrySemanticConventions.SERVER_ADDRESS, (Object)requestURL.getHost());
                    spanForAttributes.setAttribute(TelemetrySemanticConventions.URL_SCHEME, (Object)requestURL.getProtocol());
                    RequestBody requestBody2 = body = requestInfo.content == null ? null : new RequestBody(){

                        public MediaType contentType() {
                            Set contentTypes = (Set)requestInfo.headers.getOrDefault((Object)OkHttpRequestAdapter.CONTENT_TYPE_HEADER_KEY, new HashSet());
                            if (contentTypes.isEmpty()) {
                                return null;
                            }
                            String contentType = contentTypes.toArray(new String[0])[0];
                            spanForAttributes.setAttribute(TelemetrySemanticConventions.HTTP_REQUEST_HEADER_CONTENT_TYPE, (Object)contentType);
                            return MediaType.parse((String)contentType);
                        }

                        public boolean isOneShot() {
                            return !requestInfo.content.markSupported();
                        }

                        public long contentLength() throws IOException {
                            Set contentLength = (Set)requestInfo.headers.getOrDefault((Object)OkHttpRequestAdapter.CONTENT_LENGTH_HEADER_KEY, new HashSet());
                            if (!contentLength.isEmpty()) {
                                return Long.parseLong(contentLength.toArray(new String[0])[0]);
                            }
                            if (requestInfo.content instanceof ByteArrayInputStream) {
                                ByteArrayInputStream contentStream = (ByteArrayInputStream)requestInfo.content;
                                return contentStream.available();
                            }
                            return super.contentLength();
                        }

                        public void writeTo(@Nonnull BufferedSink sink) throws IOException {
                            long contentLength = this.contentLength();
                            if (contentLength > 0L) {
                                requestInfo.content.mark((int)contentLength);
                            }
                            sink.writeAll(Okio.source((InputStream)requestInfo.content));
                            if (!this.isOneShot()) {
                                try {
                                    requestInfo.content.reset();
                                }
                                catch (Exception ex) {
                                    spanForAttributes.recordException((Throwable)ex);
                                }
                            }
                        }
                    };
                    if (body == null && (requestInfo.httpMethod.equals((Object)HttpMethod.POST) || requestInfo.httpMethod.equals((Object)HttpMethod.PATCH) || requestInfo.httpMethod.equals((Object)HttpMethod.PUT))) {
                        body = RequestBody.create((byte[])new byte[0]);
                    }
                    Request.Builder requestBuilder = new Request.Builder().url(requestURL).method(requestInfo.httpMethod.toString(), body);
                    for (Object headerEntry : requestInfo.headers.entrySet()) {
                        for (String headerValue : (Set)headerEntry.getValue()) {
                            requestBuilder.addHeader((String)headerEntry.getKey(), headerValue);
                        }
                    }
                    boolean obsOptionsPresent = false;
                    for (RequestOption option : requestInfo.getRequestOptions()) {
                        if (option.getType() == this.obsOptions.getType()) {
                            obsOptionsPresent = true;
                        }
                        requestBuilder.tag(option.getType(), (Object)option);
                    }
                    if (!obsOptionsPresent) {
                        requestBuilder.tag(this.obsOptions.getType(), (Object)this.obsOptions);
                    }
                    requestBuilder.tag(Span.class, (Object)parentSpan);
                    Request request2 = requestBuilder.build();
                    if (request2 != null && (requestBody = request2.body()) != null && (contentLength = requestBody.contentLength()) >= 0L) {
                        spanForAttributes.setAttribute(TelemetrySemanticConventions.EXPERIMENTAL_HTTP_REQUEST_BODY_SIZE, (Object)contentLength);
                    }
                    request = request2;
                    if (scope == null) break block17;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return request;
        }
        finally {
            span.end();
        }
    }
}

