/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DLLException;
import com.microsoft.sqlserver.jdbc.FedAuthDllInfo;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSPIAuthentication;
import java.util.logging.Logger;

final class AuthenticationJNI
extends SSPIAuthentication {
    private static final int maximumpointersize = 128;
    private static boolean enabled = false;
    private static Logger authLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.AuthenticationJNI");
    private static int sspiBlobMaxlen = 0;
    private byte[] sniSec = new byte[128];
    private int[] sniSecLen = new int[]{0};
    private final String DNSName;
    private final int port;
    private SQLServerConnection con;
    private static final UnsatisfiedLinkError linkError;

    static int GetMaxSSPIBlobSize() {
        return sspiBlobMaxlen;
    }

    AuthenticationJNI(SQLServerConnection con, String address, int serverport) throws SQLServerException {
        if (!enabled) {
            con.terminate(0, SQLServerException.getErrString("R_notConfiguredForIntegrated"), linkError);
        }
        this.con = con;
        this.DNSName = AuthenticationJNI.GetDNSName(address);
        this.port = serverport;
    }

    static FedAuthDllInfo getAccessTokenForWindowsIntegrated(String stsURL, String servicePrincipalName, String clientConnectionId, String clientId, long expirationFileTime) throws DLLException {
        FedAuthDllInfo dllInfo = AuthenticationJNI.ADALGetAccessTokenForWindowsIntegrated(stsURL, servicePrincipalName, clientConnectionId, clientId, expirationFileTime, authLogger);
        return dllInfo;
    }

    @Override
    byte[] GenerateClientContext(byte[] pin, boolean[] done) throws SQLServerException {
        int[] outsize = new int[]{AuthenticationJNI.GetMaxSSPIBlobSize()};
        byte[] pOut = new byte[outsize[0]];
        assert (this.DNSName != null);
        int failure = AuthenticationJNI.SNISecGenClientContext(this.sniSec, this.sniSecLen, pin, pin.length, pOut, outsize, done, this.DNSName, this.port, null, null, authLogger);
        if (failure != 0) {
            authLogger.warning(this.toString() + " Authentication failed code : " + failure);
            this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), linkError);
        }
        byte[] output = new byte[outsize[0]];
        System.arraycopy(pOut, 0, output, 0, outsize[0]);
        return output;
    }

    @Override
    int ReleaseClientContext() {
        int success = 0;
        if (this.sniSecLen[0] > 0) {
            success = AuthenticationJNI.SNISecReleaseClientContext(this.sniSec, this.sniSecLen[0], authLogger);
            this.sniSecLen[0] = 0;
        }
        return success;
    }

    private static String GetDNSName(String address) {
        String[] DNS = new String[1];
        if (AuthenticationJNI.GetDNSName(address, DNS, authLogger) != 0) {
            DNS[0] = address;
        }
        return DNS[0];
    }

    private static native int SNISecGenClientContext(byte[] var0, int[] var1, byte[] var2, int var3, byte[] var4, int[] var5, boolean[] var6, String var7, int var8, String var9, String var10, Logger var11);

    private static native int SNISecReleaseClientContext(byte[] var0, int var1, Logger var2);

    private static native int SNISecInitPackage(int[] var0, Logger var1);

    private static native int SNISecTerminatePackage(Logger var0);

    private static native int SNIGetSID(byte[] var0, Logger var1);

    private static native boolean SNIIsEqualToCurrentSID(byte[] var0, Logger var1);

    private static native int GetDNSName(String var0, String[] var1, Logger var2);

    private static native FedAuthDllInfo ADALGetAccessTokenForWindowsIntegrated(String var0, String var1, String var2, String var3, long var4, Logger var6);

    static native byte[] DecryptColumnEncryptionKey(String var0, String var1, byte[] var2) throws DLLException;

    static {
        UnsatisfiedLinkError temp = null;
        try {
            String libName = "sqljdbc_auth";
            System.loadLibrary(libName);
            int[] pkg = new int[]{0};
            if (0 != AuthenticationJNI.SNISecInitPackage(pkg, authLogger)) {
                throw new UnsatisfiedLinkError();
            }
            sspiBlobMaxlen = pkg[0];
            enabled = true;
        }
        catch (UnsatisfiedLinkError e) {
            temp = e;
            authLogger.warning("Failed to load the sqljdbc_auth.dll cause : " + e.getMessage());
        }
        finally {
            linkError = temp;
        }
    }
}

