/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.util;

import java.util.NoSuchElementException;
import java.util.Vector;

public class Queue {
    private Node head = null;
    private Node tail = null;
    private int size = 0;

    public void enqueue(Object o) {
        this.tail = this.tail == null ? (this.head = new Node(o)) : (this.tail.next = new Node(o));
        ++this.size;
    }

    public Object dequeue() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        Object o = this.head.data;
        if (this.head == this.tail) {
            this.head = null;
            this.tail = null;
        } else {
            this.head = this.head.next;
        }
        --this.size;
        return o;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public int size() {
        return this.size;
    }

    public static void main(String[] args) {
        int i;
        Queue q = new Queue();
        Vector<Integer> v = new Vector<Integer>();
        int count = Integer.parseInt(args[0]);
        System.out.println("Start vector");
        long start = System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            v.addElement(new Integer(i));
        }
        while (!v.isEmpty()) {
            v.removeElementAt(0);
        }
        System.out.println("Done vector; elapsed time: " + (System.currentTimeMillis() - start));
        System.out.println("Start queue");
        start = System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            q.enqueue(new Integer(i));
        }
        while (!q.isEmpty()) {
            q.dequeue();
        }
        System.out.println("Done queue; elapsed time: " + (System.currentTimeMillis() - start));
    }

    private class Node {
        public Object data;
        public Node next;

        public Node(Object data) {
            this.data = data;
            this.next = null;
        }
    }
}

