/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.saturn.cfca;

import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.EnvelopeUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.x509.certificate.X509Cert;
import com.huifu.saturn.cfca.CryptEnum;
import com.huifu.saturn.cfca.CryptResult;
import java.security.PrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFCAEnvelopeMessage {
    static Logger logger = LoggerFactory.getLogger(CFCAEnvelopeMessage.class);

    public static CryptResult encryptEnvelopeMessage(String pfxFilePath, String pfxFilePwd, String srcData, String symAlg, String charset) {
        try {
            X509Cert x509Cert = CertUtil.getCertFromPFX((String)pfxFilePath, (String)pfxFilePwd);
            X509Cert[] certs = new X509Cert[]{x509Cert};
            byte[] encryptedData = EnvelopeUtil.envelopeMessage((byte[])srcData.getBytes(charset), (String)symAlg, (X509Cert[])certs, (Session)CFCAEnvelopeMessage.getSession());
            CryptResult cryptResult = new CryptResult(CryptEnum.SUCCESS);
            cryptResult.setContent(encryptedData);
            return cryptResult;
        }
        catch (Exception e) {
            logger.error("encryptEnvelopeMessage error:", (Throwable)e);
            return new CryptResult(CryptEnum.FAILED);
        }
    }

    public static CryptResult decryptEnvelopeMessage(String pfxFilePath, String pfxFilePwd, byte[] encryptedData) {
        try {
            PrivateKey priKey = KeyUtil.getPrivateKeyFromPFX((String)pfxFilePath, (String)pfxFilePwd);
            X509Cert x509Cert = CertUtil.getCertFromPFX((String)pfxFilePath, (String)pfxFilePwd);
            byte[] sourceData = EnvelopeUtil.openEvelopedMessage((byte[])encryptedData, (PrivateKey)priKey, (X509Cert)x509Cert, (Session)CFCAEnvelopeMessage.getSession());
            CryptResult cryptResult = new CryptResult(CryptEnum.SUCCESS);
            cryptResult.setContent(sourceData);
            return cryptResult;
        }
        catch (Exception e) {
            logger.error("decryptEnvelopeMessage error:", (Throwable)e);
            return new CryptResult(CryptEnum.FAILED);
        }
    }

    public static Session getSession() throws Exception {
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        return JCrypto.getInstance().openSession("JSOFT_LIB");
    }
}

