/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.saturn.cfca;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertVerifier;
import com.huifu.saturn.cfca.Base64;
import com.huifu.saturn.cfca.CFCAException;
import com.huifu.saturn.cfca.CFCASignature;
import com.huifu.saturn.cfca.VerifyEnum;
import com.huifu.saturn.cfca.VerifyResult;
import com.huifu.saturn.cfca.util.StringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFCAVerify {
    private static Logger logger = LoggerFactory.getLogger(CFCASignature.class);

    public static void verifyCerDate(X509Cert userX509Cert, String trustCerPath) throws CFCAException {
        if (trustCerPath != null) {
            if (X509CertVerifier.verifyCertDate((X509Cert)userX509Cert)) {
                logger.info("userX509Cert date is valid:" + userX509Cert.getNotBefore() + "---" + userX509Cert.getNotAfter());
            } else {
                logger.warn("Cert out of date:" + userX509Cert.getNotBefore() + "---" + userX509Cert.getNotAfter());
                throw new CFCAException(VerifyEnum.CERT_EXPRIED);
            }
        }
    }

    public static void verifyCer(X509Cert userX509Cert, String trustCerPath) throws CFCAException {
        block4: {
            try {
                if (trustCerPath == null) break block4;
                FileInputStream inputStream = new FileInputStream(trustCerPath);
                X509CertVerifier.updateTrustCertsMap((X509Cert)new X509Cert((InputStream)inputStream));
                if (X509CertVerifier.validateCertSign((X509Cert)userX509Cert)) {
                    logger.info("userX509Cert is right!");
                    break block4;
                }
                logger.warn("userX509Cert is wrong!");
                throw new CFCAException(VerifyEnum.CERT_ILLEGAL);
            }
            catch (PKIException e) {
                logger.error("verifyCer error:", (Throwable)e);
                throw new CFCAException(VerifyEnum.FAILED);
            }
            catch (FileNotFoundException e) {
                logger.error("verifyCer FileNotFoundException error:", (Throwable)e);
                throw new CFCAException(VerifyEnum.FAILED);
            }
        }
    }

    public static void verifyCRL(X509Cert userX509Cert, String crlFilePath) throws CFCAException {
        block3: {
            try {
                if (crlFilePath == null) break block3;
                if (X509CertVerifier.verifyCertByCRLOutLine((X509Cert)userX509Cert, (String)crlFilePath)) {
                    logger.info("userX509Cert is valid in crl");
                    break block3;
                }
                logger.warn("userX509Cert is revoked in crl");
                throw new CFCAException(VerifyEnum.CERT_REVOKED);
            }
            catch (PKIException e) {
                logger.error("verifyCRL error:", (Throwable)e);
                throw new CFCAException(VerifyEnum.FAILED);
            }
        }
    }

    public static void verifyMer(Signature sigUtil, String merId, byte[] bytes) throws CFCAException {
        try {
            String subject = sigUtil.getSignerX509CertFromP7SignData(bytes).getSubject();
            if (StringUtils.isBlank(merId)) {
                logger.warn("merId is blank. merId=" + merId);
                throw new CFCAException(VerifyEnum.MER_FAILED);
            }
            if (!subject.contains(merId)) {
                logger.warn("subject not contains merId. subject=" + subject + ",merId=" + merId);
                throw new CFCAException(VerifyEnum.MER_FAILED);
            }
        }
        catch (PKIException e) {
            logger.error("verifyMer error:", (Throwable)e);
            throw new CFCAException(VerifyEnum.FAILED);
        }
    }

    public static VerifyResult verifyP7VerifyMessageAttach(Signature sigUtil, byte[] bytes, Session session) throws CFCAException {
        try {
            boolean isSign = sigUtil.p7VerifyMessageAttach(bytes, session);
            if (!isSign) {
                throw new CFCAException(VerifyEnum.SIGN_ERROR);
            }
            logger.info("p7 dig alg with verification: " + sigUtil.getDigestAlgorithm());
            logger.info("p7 cert subject with verification:" + sigUtil.getSignerCert().getSubject());
            logger.info("p7 signature: " + new String(Base64.encodeBase64(sigUtil.getSignature())));
            logger.info("RSA P7 attach verify OK!");
            VerifyResult verifyResult = new VerifyResult(VerifyEnum.SUCCESS);
            verifyResult.setContent(sigUtil.getSourceData());
            return verifyResult;
        }
        catch (PKIException e) {
            logger.error("verifyP7VerifyMessageAttach error:", (Throwable)e);
            throw new CFCAException(VerifyEnum.FAILED);
        }
    }
}

