/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.saturn.cfca;

import com.huifu.saturn.cfca.CFCASignature;
import com.huifu.saturn.cfca.util.StringUtils;
import java.io.File;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLDownload {
    private Logger logger = LoggerFactory.getLogger(CFCASignature.class);
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private String crlURL = "http://crl.cfca.com.cn/RSA/allCRL.crl";
    private String downloadPath;
    private int scheduleInitDelayTime = 10;
    private int schedulePeriodTime = 7200;

    public void start() {
        if (StringUtils.isBlank(this.downloadPath)) {
            this.logger.warn("downloadPath is blank. start cancel.");
            this.stop();
            return;
        }
        this.logger.info("start to download crl file. crlUrl={},downloadPaht={}", (Object)this.crlURL, (Object)this.downloadPath);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    URL httpurl = new URL(CRLDownload.this.crlURL);
                    File dirs = new File(CRLDownload.this.downloadPath);
                    dirs.mkdirs();
                    File f = new File(CRLDownload.this.downloadPath + File.separator + "crl.crl");
                    FileUtils.copyURLToFile((URL)httpurl, (File)f);
                    CRLDownload.this.logger.info("download crl file success.");
                }
                catch (Exception e) {
                    CRLDownload.this.logger.error("download crlURL error.", (Throwable)e);
                }
                CRLDownload.this.logger.info("end to download crl file.");
            }
        });
        this.executorService.scheduleAtFixedRate(thread, this.scheduleInitDelayTime, this.schedulePeriodTime, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public void setDownloadPath(String downloadPath) {
        this.downloadPath = downloadPath;
    }

    public String getCrlURL() {
        return this.crlURL;
    }

    public void setCrlURL(String crlURL) {
        this.crlURL = crlURL;
    }

    public int getScheduleInitDelayTime() {
        return this.scheduleInitDelayTime;
    }

    public void setScheduleInitDelayTime(int scheduleInitDelayTime) {
        this.scheduleInitDelayTime = scheduleInitDelayTime;
    }

    public int getSchedulePeriodTime() {
        return this.schedulePeriodTime;
    }

    public void setSchedulePeriodTime(int schedulePeriodTime) {
        this.schedulePeriodTime = schedulePeriodTime;
    }
}

