/*
 * Decompiled with CFR 0.152.
 */
package chinapnr;

import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertVerifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Cfca {
    public static final String SUCCESS = "0";
    public static final String FAIL = "1";

    public Result signCfca(String message, String charset, String privateCfcaPath, String privateCfcaPass) {
        Result result = new Result();
        try {
            JCrypto.getInstance().initialize("JSOFT_LIB", null);
            Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
            String RSASignAlg = "sha1WithRSAEncryption";
            PrivateKey privateKey = KeyUtil.getPrivateKeyFromPFX((String)privateCfcaPath, (String)privateCfcaPass);
            X509Cert cert = CertUtil.getCertFromPFX((String)privateCfcaPath, (String)privateCfcaPass);
            Signature signature = new Signature();
            byte[] chkValue = signature.p7SignMessageAttach(RSASignAlg, message.getBytes(charset), privateKey, cert, session);
            if (chkValue != null) {
                ByteArrayOutputStream out = null;
                GZIPOutputStream gzip = null;
                try {
                    out = new ByteArrayOutputStream();
                    gzip = new GZIPOutputStream(out);
                    gzip.write(chkValue);
                    gzip.finish();
                    gzip.flush();
                    chkValue = out.toByteArray();
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (gzip != null) {
                        try {
                            gzip.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                result.setCode(SUCCESS);
                result.setMessage(URLEncoder.encode(Base64.toBase64String((byte[])chkValue), charset));
                return result;
            }
            result.setCode(FAIL);
            result.setMessage("\u5931\u8d25");
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setCode(FAIL);
            result.setMessage("\u5f02\u5e38");
            return result;
        }
    }

    public Result verifySignCfca(String merId, String message, String chkValue, String charset, String publicCfcaPath) {
        Result result = new Result();
        ByteArrayOutputStream out = null;
        GZIPInputStream gzip = null;
        try {
            String merIdCert;
            JCrypto.getInstance().initialize("JSOFT_LIB", null);
            Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
            Signature signature = new Signature();
            byte[] chkValueByte = null;
            chkValueByte = chkValue.indexOf("%") >= 0 ? Base64.decode((String)URLDecoder.decode(chkValue, charset)) : Base64.decode((String)chkValue);
            out = new ByteArrayOutputStream();
            gzip = new GZIPInputStream(new ByteArrayInputStream(chkValueByte));
            int b = 0;
            while ((b = gzip.read()) != -1) {
                out.write(b);
            }
            chkValueByte = out.toByteArray();
            X509Cert cert = signature.getSignerX509CertFromP7SignData(chkValueByte);
            X509CertVerifier.updateTrustCertsMap((String)publicCfcaPath);
            if (!X509CertVerifier.validateCertSign((X509Cert)cert)) {
                result.setCode(FAIL);
                result.setMessage("\u8bc1\u4e66\u65e0\u6548");
                Result result2 = result;
                return result2;
            }
            if (!X509CertVerifier.verifyCertDate((X509Cert)cert)) {
                result.setCode(FAIL);
                result.setMessage("\u8bc1\u4e66\u8fc7\u671f");
                Result result3 = result;
                return result3;
            }
            if (signature.p7VerifyMessageAttach(chkValueByte, session) && !merId.equals((merIdCert = signature.getSignerCert().getSubject()).substring(merIdCert.indexOf(64) + 1, merIdCert.indexOf(64) + 7))) {
                result.setCode(FAIL);
                result.setMessage("\u975e\u5546\u6237\u8bc1\u4e66");
                Result result4 = result;
                return result4;
            }
            if (!message.equals(new String(signature.getSourceData(), charset))) {
                result.setCode(FAIL);
                result.setMessage("\u7b7e\u540d\u4fe1\u606f\u4e0d\u6b63\u786e");
                Result result5 = result;
                return result5;
            }
            result.setCode(SUCCESS);
            result.setMessage("\u9a8c\u7b7e\u6210\u529f");
            Result result6 = result;
            return result6;
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setCode(FAIL);
            result.setMessage("\u9a8c\u7b7e\u5f02\u5e38");
            Result result7 = result;
            return result7;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class Result {
        private String code;
        private String message;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

