/*
 * Decompiled with CFR 0.152.
 */
package chinapnr;

import chinapnr.PrivateKey;
import java.math.BigInteger;

public class RSAEncrypt {
    private BigInteger p;
    private BigInteger q;
    private BigInteger a;
    private BigInteger b;
    private BigInteger u;
    private BigInteger dP;
    private BigInteger dQ;

    public RSAEncrypt(PrivateKey privateKey) {
        try {
            this.p = new BigInteger(1, privateKey.Prime[0]);
            this.q = new BigInteger(1, privateKey.Prime[1]);
            this.u = new BigInteger(1, privateKey.Coefficient);
            this.dP = new BigInteger(1, privateKey.PrimeExponent[0]);
            this.dQ = new BigInteger(1, privateKey.PrimeExponent[1]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public String EncryptMessage(byte[] byArray) {
        String string;
        BigInteger bigInteger = new BigInteger(1, byArray);
        try {
            BigInteger bigInteger2;
            BigInteger bigInteger3 = bigInteger.mod(this.p);
            BigInteger bigInteger4 = bigInteger.mod(this.q);
            this.a = bigInteger3.modPow(this.dP, this.p);
            this.b = bigInteger4.modPow(this.dQ, this.q);
            if (this.a.compareTo(this.b) >= 0) {
                bigInteger2 = this.a.subtract(this.b);
            } else {
                bigInteger2 = this.b.subtract(this.a);
                bigInteger2 = this.p.subtract(bigInteger2);
            }
            bigInteger2 = bigInteger2.mod(this.p).multiply(this.u).mod(this.p).multiply(this.q).add(this.b);
            string = bigInteger2.toString(16);
            while (string.length() < 256) {
                string = '0' + string;
            }
        }
        catch (ArithmeticException arithmeticException) {
            return null;
        }
        return string;
    }
}

