/*
 * Decompiled with CFR 0.152.
 */
package chinapnr;

import chinapnr.DesRsa;
import chinapnr.PrivateKey;
import chinapnr.RSAEncrypt;
import chinapnr.ShaHash;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Random;

public class SecureLink {
    private String EncMsg;
    private String DecTxt;
    private byte[] MsgData;
    private String ChkValue;
    private String EncPin;
    private PrivateKey privateKey = new PrivateKey();
    private Socket sid = null;
    private byte[] DesKey = new byte[16];
    private DataOutputStream out = null;
    private DataInputStream in = null;
    private String TRANS_TYPE;
    private String TransStat;
    private String SysDate;
    private String SysSeqId;
    private String GateId;
    private String MerPriv;

    public int SignOrder(String MerId, String MerKeyFile, String OrdId, String TransAmt, String MerDate, String TransType, String GateId, String MerPriv, String BgRetUrl, String PageRetUrl) {
        char ch;
        if (GateId == null) {
            GateId = "";
        }
        if (MerPriv == null) {
            MerPriv = "";
        }
        if (BgRetUrl == null) {
            BgRetUrl = "";
        }
        if (PageRetUrl == null) {
            PageRetUrl = "";
        }
        if (MerDate.length() != 8 || MerId.length() != 6 || GateId.length() > 2 || MerPriv.length() > 120 || BgRetUrl.length() > 120 || PageRetUrl.length() > 120 || OrdId.length() > 16 || OrdId.length() < 6 || TransType.length() != 1 || TransAmt.length() > 12 || TransAmt.length() < 4) {
            return -201;
        }
        int len = TransAmt.length();
        int ret = 0;
        while (ret < len) {
            ch = TransAmt.charAt(ret);
            if (ret == 0) {
                if (ch > '9' || ch < '0') {
                    return -202;
                }
                if (ch == '0' && len != 4) {
                    return -202;
                }
            }
            if (ret == len - 3 ? ch != '.' : ch > '9' || ch < '0') {
                return -202;
            }
            ++ret;
        }
        ret = 0;
        while (ret < OrdId.length()) {
            ch = OrdId.charAt(ret);
            if (ch < '0' || ch > '9') {
                return -203;
            }
            ++ret;
        }
        String MerData = String.valueOf(MerId) + OrdId + TransAmt + MerDate + TransType + GateId + MerPriv + BgRetUrl + PageRetUrl;
        return this.SignMsg(MerId, MerKeyFile, MerData);
    }

    public int SignMsg(String MerId, String MerKeyFile, String MsgData) {
        return this.SignMsg(MerId, MerKeyFile, MsgData.getBytes());
    }

    public int SignMsg(String MerId, String MerKeyFile, byte[] MsgBuf) {
        boolean flag = this.privateKey.buildKey(MerId, 0, MerKeyFile);
        if (!flag) {
            System.out.println("build key error!");
            return -101;
        }
        int MsgLen = MsgBuf.length;
        byte[] data = new byte[MsgLen];
        byte[] hb = new byte[128];
        byte[] md5out = new byte[16];
        if (MsgLen > 9900) {
            return -401;
        }
        RSAEncrypt S = new RSAEncrypt(this.privateKey);
        SecureLink.fillBlock(data, (byte)0);
        System.arraycopy(MsgBuf, 0, data, 0, MsgLen);
        ShaHash hash = new ShaHash();
        hash.add(data, 0, MsgLen);
        hb = hash.get();
        String rb = S.EncryptMessage(hb);
        this.ChkValue = rb.toUpperCase();
        return 0;
    }

    public int VeriSignOrder(String MerId, String PgKeyFile, String OrdId, String TransAmt, String MerDate, String TransType, String TransStat, String GateId, String MerPriv, String SysDate, String SysSeqId, String ChkValue) {
        if (MerDate.length() != 8 || MerId.length() != 6 || OrdId.length() > 16 || OrdId.length() < 6 || TransType.length() != 1 || TransStat.length() != 1 || GateId.length() != 2 || SysDate.length() != 8 || SysSeqId.length() != 6 || ChkValue.length() != 256 || TransAmt.length() > 12 || TransAmt.length() < 4) {
            return -201;
        }
        if (MerPriv == null) {
            MerPriv = "";
        }
        String MerData = String.valueOf(MerId) + OrdId + TransAmt + MerDate + TransType + TransStat + GateId + MerPriv + SysDate + SysSeqId;
        return this.VeriSignMsg(PgKeyFile, MerData, ChkValue);
    }

    public int VeriSignMsg(String PgKeyFile, String MsgData, String ChkValue) {
        boolean flag = this.privateKey.buildKey("999999", 0, PgKeyFile);
        if (!flag) {
            System.out.println("build key error!");
            return -101;
        }
        byte[] data = new byte[9900];
        byte[] MsgBuf = MsgData.getBytes();
        int MsgLen = MsgBuf.length;
        if (MsgLen > 9900) {
            return -401;
        }
        SecureLink.fillBlock(data, (byte)0);
        System.arraycopy(MsgBuf, 0, data, 0, MsgLen);
        ShaHash hash = new ShaHash();
        hash.add(data, 0, MsgLen);
        byte[] hb = hash.get();
        String rb = this.DecryptMessage(ChkValue);
        String sb = SecureLink.toStringBlock(hb);
        if (sb.equalsIgnoreCase(rb)) {
            return 0;
        }
        return -301;
    }

    public int VeriSignMsg(String PgKeyFile, byte[] MsgBuf, String ChkValue) {
        boolean flag = this.privateKey.buildKey("999999", 0, PgKeyFile);
        if (!flag) {
            System.out.println("build key error!");
            return -101;
        }
        byte[] data = new byte[9900];
        int MsgLen = MsgBuf.length;
        if (MsgLen > 9900) {
            return -401;
        }
        SecureLink.fillBlock(data, (byte)0);
        System.arraycopy(MsgBuf, 0, data, 0, MsgLen);
        ShaHash hash = new ShaHash();
        hash.add(data, 0, MsgLen);
        byte[] hb = hash.get();
        String rb = this.DecryptMessage(ChkValue);
        String sb = SecureLink.toStringBlock(hb);
        if (sb.equalsIgnoreCase(rb)) {
            return 0;
        }
        return -301;
    }

    public int SignFile(String MerId, String MerKeyFile, String fullFileName) {
        Object fileContent = null;
        byte[] DataBuf = null;
        try {
            File file = new File(fullFileName);
            DataBuf = new byte[(int)file.length()];
            FileInputStream fileReader = new FileInputStream(file);
            fileReader.read(DataBuf);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return -801;
        }
        byte[] hb = new byte[128];
        ShaHash hash = new ShaHash();
        hash.add(DataBuf, 0, DataBuf.length);
        hb = hash.get();
        BigInteger sha = new BigInteger(1, hb);
        String out = sha.toString(16);
        while (out.length() < 256) {
            out = String.valueOf('0') + out;
        }
        int ret = this.SignMsg(MerId, MerKeyFile, out = out.toUpperCase());
        if (ret != 0) {
            return ret;
        }
        byte[] bChkLine = ("\n" + this.ChkValue).getBytes();
        byte[] bNewData = new byte[DataBuf.length + bChkLine.length];
        SecureLink.append(bNewData, 0, DataBuf, DataBuf.length, 'r');
        SecureLink.append(bNewData, DataBuf.length, bChkLine, bChkLine.length, 'r');
        try {
            String newFileName = String.valueOf(fullFileName.substring(0, fullFileName.length() - 4)) + "_SIGN.txt";
            File file = new File(newFileName);
            FileOutputStream fileWriter = new FileOutputStream(file);
            fileWriter.write(bNewData);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return -803;
        }
        return 0;
    }

    private String DecryptMessage(String input) {
        BigInteger result;
        try {
            BigInteger In = new BigInteger(input, 16);
            BigInteger Modulus = new BigInteger(1, this.privateKey.Modulus);
            BigInteger Exponent = new BigInteger("010001", 16);
            result = In.modPow(Exponent, Modulus);
        }
        catch (NumberFormatException _ex) {
            return "-1";
        }
        String rb = result.toString(16);
        while (rb.length() < 256) {
            rb = "0" + rb;
        }
        return rb;
    }

    private static void fillBlock(byte[] block, byte b) {
        SecureLink.fillBlock(block, 0, b, block.length);
    }

    private static void fillBlock(byte[] block, int blockOff, byte b, int len) {
        int i = blockOff;
        while (i < blockOff + len) {
            block[i] = b;
            ++i;
        }
    }

    public String rightPad(String str, int len, char ch) {
        int p = len - str.length();
        String nstr = "";
        int i = 0;
        while (i < p) {
            nstr = String.valueOf(nstr) + ch;
            ++i;
        }
        nstr = String.valueOf(str) + nstr;
        return nstr;
    }

    public String genRandom(int len) {
        String result = "";
        Random ran = new Random();
        String sValue = String.valueOf(Math.abs(ran.nextLong()));
        result = sValue.length() >= len ? sValue.substring(0, len) : this.rightPad(sValue, len, '0');
        return result;
    }

    public String Sign(String MsgBody, int MsgLen) {
        byte[] data = new byte[500];
        ShaHash hash = new ShaHash();
        RSAEncrypt S = new RSAEncrypt(this.privateKey);
        SecureLink.fillBlock(data, (byte)0);
        byte[] tmp = MsgBody.getBytes();
        System.arraycopy(tmp, 0, data, 0, MsgLen);
        hash.add(data, 0, MsgLen);
        byte[] hb = hash.get();
        String rb = S.EncryptMessage(hb);
        return rb.toUpperCase();
    }

    public String genSign(String MerID, String OrderNO, String Amount, String CurrencyCode, String TransDate, String TransType) {
        ShaHash hash = new ShaHash();
        RSAEncrypt S = new RSAEncrypt(this.privateKey);
        int len = MerID.length();
        if (len > 15) {
            MerID = MerID.substring(0, 15);
        }
        if ((len = OrderNO.length()) > 16) {
            OrderNO = OrderNO.substring(0, 16);
        }
        if ((len = Amount.length()) > 12) {
            Amount = Amount.substring(0, 12);
        }
        if ((len = CurrencyCode.length()) > 3) {
            CurrencyCode = CurrencyCode.substring(0, 3);
        }
        if ((len = TransDate.length()) > 8) {
            TransDate = TransDate.substring(0, 8);
        }
        if ((len = TransType.length()) > 4) {
            TransType = TransType.substring(0, 4);
        }
        String MsgBody = "";
        MsgBody = String.valueOf(MsgBody) + MerID + OrderNO + Amount + CurrencyCode + TransDate + TransType;
        int MsgLen = MsgBody.length();
        return this.Sign(MsgBody, MsgLen);
    }

    public static boolean memcmp(byte[] out, byte[] in, int len) {
        int i = 0;
        while (i < len) {
            if (out[i] != in[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String toStringBlock(byte[] block) {
        return SecureLink.toStringBlock(block, 0, block.length);
    }

    private static String toStringBlock(byte[] block, int off, int len) {
        String hexits = "0123456789abcdef";
        StringBuffer buf = new StringBuffer();
        int i = off;
        while (i < off + len) {
            buf.append(hexits.charAt(block[i] >>> 4 & 0xF));
            buf.append(hexits.charAt(block[i] & 0xF));
            ++i;
        }
        return String.valueOf(String.valueOf(buf));
    }

    public boolean verifyAuthToken(String MerID, String OrderNO, String Amount, String CurrencyCode, String TransDate, String TransType, String TransCode, String ChkValue) {
        byte[] data = new byte[100];
        int len = 0;
        ShaHash hash = new ShaHash();
        SecureLink.fillBlock(data, (byte)0);
        byte[] tmp = MerID.getBytes();
        len = MerID.length();
        if (len > 15) {
            len = 15;
        }
        System.arraycopy(tmp, 0, data, 0, len);
        tmp = OrderNO.getBytes();
        len = OrderNO.length();
        if (len > 16) {
            len = 16;
        }
        System.arraycopy(tmp, 0, data, 15, len);
        tmp = Amount.getBytes();
        len = Amount.length();
        if (len > 12) {
            len = 12;
        }
        System.arraycopy(tmp, 0, data, 31, len);
        tmp = CurrencyCode.getBytes();
        len = CurrencyCode.length();
        if (len > 3) {
            len = 3;
        }
        System.arraycopy(tmp, 0, data, 43, len);
        tmp = TransDate.getBytes();
        len = TransDate.length();
        if (len > 8) {
            len = 8;
        }
        System.arraycopy(tmp, 0, data, 46, len);
        tmp = TransType.getBytes();
        len = TransType.length();
        if (len > 4) {
            len = 4;
        }
        System.arraycopy(tmp, 0, data, 54, len);
        if (TransCode != null) {
            tmp = TransCode.getBytes();
            len = TransCode.length();
            if (len > 4) {
                len = 4;
            }
            System.arraycopy(tmp, 0, data, 58, len);
        }
        hash.add(data, 0, 62);
        byte[] hb = hash.get();
        String rb = this.DecryptMessage(ChkValue);
        String sb = SecureLink.toStringBlock(hb);
        return sb.equalsIgnoreCase(rb);
    }

    public boolean verifyTransResponse(String MerID, String OrderNO, String Amount, String CurrencyCode, String TransDate, String TransType, String TransCode, String ChkValue) {
        return this.verifyAuthToken(MerID, OrderNO, Amount, CurrencyCode, TransDate, TransType, TransCode, ChkValue);
    }

    public static byte[] md5Digest(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input);
            byte[] toChapter1Digest = md.digest();
            return toChapter1Digest;
        }
        catch (Exception e) {
            return "error".getBytes();
        }
    }

    public static byte[] md5digestAdd128(byte[] input) {
        int hashSize = input.length;
        byte[] hb = new byte[128];
        byte[] byArray = new byte[128];
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = -1;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[48] = -1;
        byArray[49] = -1;
        byArray[50] = -1;
        byArray[51] = -1;
        byArray[52] = -1;
        byArray[53] = -1;
        byArray[54] = -1;
        byArray[55] = -1;
        byArray[56] = -1;
        byArray[57] = -1;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[65] = -1;
        byArray[66] = -1;
        byArray[67] = -1;
        byArray[68] = -1;
        byArray[69] = -1;
        byArray[70] = -1;
        byArray[71] = -1;
        byArray[72] = -1;
        byArray[73] = -1;
        byArray[74] = -1;
        byArray[75] = -1;
        byArray[76] = -1;
        byArray[77] = -1;
        byArray[78] = -1;
        byArray[79] = -1;
        byArray[80] = -1;
        byArray[81] = -1;
        byArray[82] = -1;
        byArray[83] = -1;
        byArray[84] = -1;
        byArray[85] = -1;
        byArray[86] = -1;
        byArray[87] = -1;
        byArray[88] = -1;
        byArray[89] = -1;
        byArray[90] = -1;
        byArray[91] = -1;
        byArray[93] = 48;
        byArray[94] = 33;
        byArray[95] = 48;
        byArray[96] = 9;
        byArray[97] = 6;
        byArray[98] = 5;
        byArray[99] = 43;
        byArray[100] = 14;
        byArray[101] = 3;
        byArray[102] = 2;
        byArray[103] = 26;
        byArray[104] = 5;
        byArray[106] = 4;
        byArray[107] = 20;
        byte[] HashpadString = byArray;
        System.arraycopy(HashpadString, 0, hb, 0, 112);
        System.arraycopy(input, 0, hb, 112, 16);
        return hb;
    }

    byte[] OAEP_Two(byte[] DES_Key1, byte[] DES_Key2, byte[] IV) {
        byte[] tmpStr = "ffFIEFlw81f03frL8f2lfsg".getBytes();
        Random rd = new Random();
        byte[] R = new byte[128];
        rd.nextBytes(R);
        R[0] = 1;
        R[1] = 0;
        System.arraycopy(tmpStr, 0, R, 10, tmpStr.length);
        R[103] = 0;
        System.arraycopy(DES_Key1, 0, R, 104, 8);
        System.arraycopy(DES_Key2, 0, R, 112, 8);
        System.arraycopy(IV, 0, R, 120, 8);
        return R;
    }

    String addLenString(int len) {
        if (len > 9999) {
            return "-1";
        }
        String sOut = Integer.toString(len);
        int b = 4 - sOut.length();
        if (b != 0) {
            int i = 0;
            while (i < b) {
                sOut = "0" + sOut;
                ++i;
            }
        }
        return sOut;
    }

    int getLenString(String sIn) {
        if (sIn.length() != 4) {
            return -1;
        }
        int iOut = 0;
        try {
            Integer I = new Integer(sIn);
            iOut = I;
        }
        catch (Exception e) {
            return -2;
        }
        return iOut;
    }

    public int newEncData_J_Client(byte[] MsgData) {
        byte[] deskey1 = new byte[8];
        byte[] deskey2 = new byte[8];
        byte[] IV = "FIEf124H".getBytes();
        Random rd = new Random();
        rd.nextBytes(deskey1);
        rd.nextBytes(deskey2);
        byte[] msgKey = this.OAEP_Two(deskey1, deskey2, IV);
        int MsgDataLen = MsgData.length;
        if (MsgDataLen > 9999) {
            return -9999;
        }
        String sLen = this.addLenString(MsgDataLen);
        if (sLen.compareTo("-1") == 0) {
            return -9998;
        }
        if (sLen.length() != 4) {
            return -9997;
        }
        DesRsa dr = new DesRsa();
        String tmp = DesRsa.Hex2Asc(msgKey.length, msgKey);
        byte[] trkey = new byte[16];
        System.arraycopy(deskey1, 0, trkey, 0, 8);
        System.arraycopy(deskey2, 0, trkey, 8, 8);
        tmp = new String(MsgData);
        byte[] btrOut = dr.DES3b(trkey, MsgData);
        String strOut = DesRsa.Hex2Asc(btrOut.length, btrOut);
        String shMsgKey = DesRsa.Hex2Asc(msgKey.length, msgKey);
        String sMsgKey = this.DecryptMessage(shMsgKey);
        sMsgKey = sMsgKey.toUpperCase();
        this.EncMsg = String.valueOf(sMsgKey) + sLen + strOut;
        return 0;
    }

    public String getEncMsg() {
        return this.EncMsg;
    }

    int checkOAEP(byte[] R, byte[] trKey) {
        if (R[0] != 1) {
            return -2000;
        }
        if (R[1] != 0) {
            return 2001;
        }
        byte[] tmpStr = "ffFIEFlw81f03frL8f2lfsg".getBytes();
        int tlen = tmpStr.length;
        byte[] gettmpStr = new byte[tlen];
        System.arraycopy(R, 10, gettmpStr, 0, tlen);
        if (!Arrays.equals(tmpStr, gettmpStr)) {
            return -1009;
        }
        byte[] IV = "FIEf124H".getBytes();
        tlen = IV.length;
        byte[] getIV = new byte[tlen];
        System.arraycopy(R, 120, getIV, 0, tlen);
        if (!Arrays.equals(IV, getIV)) {
            return -1008;
        }
        if (trKey.length != 16) {
            return -2;
        }
        System.arraycopy(R, 104, trKey, 0, 16);
        return 0;
    }

    int getMsgKey(String CipherTxt, byte[] ClearTxt) {
        if (CipherTxt.length() != 256) {
            return -2;
        }
        if (ClearTxt.length != 128) {
            return -3;
        }
        RSAEncrypt S = new RSAEncrypt(this.privateKey);
        byte[] cpt = DesRsa.Asc2Hex(CipherTxt.length(), CipherTxt);
        String rb = S.EncryptMessage(cpt);
        byte[] br = DesRsa.Asc2Hex(rb.length(), rb);
        String s = DesRsa.Hex2Asc(br.length, br);
        if (rb.compareTo("-1") == 0) {
            return -1;
        }
        System.arraycopy(br, 0, ClearTxt, 0, ClearTxt.length);
        return 0;
    }

    public int newDecData_J_Client(String EncMsg) {
        String msgKeyCipher = EncMsg.substring(0, 256);
        String sLen = EncMsg.substring(256, 260);
        String desResult = EncMsg.substring(260);
        int DataLen = this.getLenString(sLen);
        if (DataLen <= 0) {
            return -8999;
        }
        byte[] deskey = new byte[128];
        int rs = this.getMsgKey(msgKeyCipher, deskey);
        if (rs != 0) {
            return rs;
        }
        String s = DesRsa.Hex2Asc(deskey.length, deskey);
        byte[] trkey = new byte[16];
        rs = this.checkOAEP(deskey, trkey);
        if (rs != 0) {
            return rs;
        }
        DesRsa dr = new DesRsa();
        byte[] bDec = dr._DES3bs(trkey, desResult.getBytes());
        int blen = bDec.length;
        this.MsgData = new byte[DataLen];
        System.arraycopy(bDec, 0, this.MsgData, 0, DataLen);
        return 0;
    }

    public byte[] getDecMsg() {
        return this.MsgData;
    }

    public String getMsgData() {
        try {
            this.DecTxt = new String(this.MsgData);
        }
        catch (Exception e) {
            return "-1";
        }
        return this.DecTxt;
    }

    public int newSignData_J_Client(int HashType, byte[] MsgData) {
        int MsgLen = MsgData.length;
        byte[] data = new byte[MsgLen];
        byte[] hb = new byte[128];
        byte[] md5out = new byte[16];
        if (MsgLen > 10240) {
            return -2;
        }
        RSAEncrypt S = new RSAEncrypt(this.privateKey);
        SecureLink.fillBlock(data, (byte)0);
        System.arraycopy(MsgData, 0, data, 0, MsgLen);
        if (HashType == 0) {
            ShaHash hash = new ShaHash();
            hash.add(data, 0, MsgLen);
            hb = hash.get();
        } else if (HashType == 1) {
            md5out = SecureLink.md5Digest(MsgData);
            hb = SecureLink.md5digestAdd128(md5out);
        } else {
            return -3;
        }
        String rb = S.EncryptMessage(hb);
        this.ChkValue = rb.toUpperCase();
        return 0;
    }

    public String getChkValue() {
        return this.ChkValue;
    }

    public int newVeriSignData_J_Client(int HashType, byte[] MsgData, String ChkValue) {
        byte[] hb;
        byte[] data = new byte[10240];
        int MsgLen = MsgData.length;
        if (MsgLen > 10240) {
            return -2;
        }
        SecureLink.fillBlock(data, (byte)0);
        System.arraycopy(MsgData, 0, data, 0, MsgLen);
        if (HashType == 0) {
            ShaHash hash = new ShaHash();
            hash.add(data, 0, MsgLen);
            hb = hash.get();
        } else if (HashType == 1) {
            hb = SecureLink.md5Digest(data);
            hb = SecureLink.md5digestAdd128(hb);
        } else {
            return -3;
        }
        String rb = this.DecryptMessage(ChkValue);
        String sb = SecureLink.toStringBlock(hb);
        if (sb.equalsIgnoreCase(rb)) {
            return 0;
        }
        return 1;
    }

    public int newEncPin_J_Client(String Pin, String MerId, String TransDate, String SeqId, String CardId) {
        if (CardId.length() < 7) {
            return -1;
        }
        DesRsa drPin = new DesRsa();
        this.EncPin = DesRsa.SingleDesEnc(Pin, CardId.substring(CardId.length() - 8).getBytes());
        return 0;
    }

    public String getEncPin() {
        return this.EncPin;
    }

    public int EncOrderMsg(String PgKeyFile, String MsgData) {
        boolean flag = this.privateKey.buildKey("999999", 0, PgKeyFile);
        if (!flag) {
            System.out.println("build key error!");
            return -101;
        }
        int ret = this.newEncData_J_Client(MsgData.getBytes());
        if (ret < 0) {
            System.out.println("encrypt msgdata error!");
            return -102;
        }
        return 0;
    }

    public int DecOrderMsg(String MerId, String MerKeyFile, String MsgData) {
        boolean flag = this.privateKey.buildKey(MerId, 0, MerKeyFile);
        if (!flag) {
            System.out.println("build key error!");
            return -101;
        }
        int i = this.newDecData_J_Client(MsgData);
        if (i < 0) {
            System.out.println("decrypt msgdata error!");
            return -102;
        }
        return 0;
    }

    public int CreateSession(String MerId, String HostName, String MerKeyFile, String PgKeyFile, String TransType) {
        String IpAddr = " ";
        try {
            InetAddress ia = InetAddress.getByName(HostName);
            IpAddr = ia.getHostAddress();
        }
        catch (UnknownHostException e) {
            System.out.println("Unknow host[" + HostName + "]IP" + IpAddr);
            System.out.println("Error " + e.toString());
            return -500;
        }
        try {
            this.sid = new Socket(IpAddr, 9123);
            this.out = new DataOutputStream(this.sid.getOutputStream());
            this.in = new DataInputStream(this.sid.getInputStream());
            this.sid.setSoTimeout(30000);
        }
        catch (IOException e) {
            return -500;
        }
        catch (Exception e) {
            return -500;
        }
        this.TRANS_TYPE = TransType;
        byte[] bData = (String.valueOf(MerId) + this.TRANS_TYPE).getBytes();
        bData = this.write_read_tcp(7, bData, 'R');
        if (!new String(bData).equals("SUCC")) {
            System.out.println("Recv[" + new String(bData) + "]");
            this.DestorySession();
            return -502;
        }
        this.genDesKey();
        boolean flag = this.privateKey.buildKey("999999", 0, PgKeyFile);
        if (!flag) {
            System.out.println("build key error!");
            this.DestorySession();
            return -101;
        }
        int ret = this.newEncData_J_Client(this.DesKey);
        if (ret < 0) {
            System.out.println("encrypt msgdata error!");
            this.DestorySession();
            return ret;
        }
        ret = this.SignMsg(MerId, MerKeyFile, this.DesKey);
        if (ret < 0) {
            this.DestorySession();
            return ret;
        }
        int len1 = this.EncMsg.length();
        bData = new byte[260 + len1];
        SecureLink.append(bData, 0, "" + len1, 4, 'r');
        SecureLink.append(bData, 4, this.EncMsg, len1, 'r');
        SecureLink.append(bData, len1 + 4, this.ChkValue, 256, 'r');
        bData = this.write_read_tcp(260 + len1, bData, 'R');
        if (!new String(bData).equals("SUCC")) {
            this.DestorySession();
            return -20;
        }
        return 0;
    }

    public int SendTrans(String OrdId, String TransAmt, String MerDate, String TransType) {
        String sData;
        String OrgData = sData = String.valueOf(MerDate) + "|" + OrdId + "|" + TransAmt + "|";
        DesRsa dr = new DesRsa();
        byte[] bData = dr.DES3b(this.DesKey, sData.getBytes());
        byte[] bTmp = new byte[bData.length + 1];
        bTmp[0] = (byte)TransType.charAt(0);
        SecureLink.append(bTmp, 1, bData, bData.length, 'r');
        bData = this.write_read_tcp(bTmp.length, bTmp, 'R');
        bTmp = SecureLink.extract(bData, 0, 4);
        sData = new String(bTmp);
        if (sData.equals("0000")) {
            bTmp = SecureLink.extract(bData, 4, bData.length - 4);
            sData = new String(bData = dr._DES3b(this.DesKey, bTmp));
            if (!OrgData.equals(sData.substring(0, OrgData.length()))) {
                return -5;
            }
            if (this.TRANS_TYPE.equals("I")) {
                int pos1 = OrgData.length();
                this.TransStat = sData.substring(pos1, pos1 + 1);
                this.SysDate = sData.substring(pos1 += 2, pos1 + 8);
                this.SysSeqId = sData.substring(pos1 += 9, pos1 + 6);
                int pos2 = sData.indexOf("|", pos1 += 7);
                this.GateId = sData.substring(pos1, pos2);
                pos1 = pos2 + 1;
                pos2 = sData.indexOf("|", pos1);
                this.MerPriv = sData.substring(pos1, pos2);
                pos1 = pos2 + 1;
            }
        } else {
            if (sData.equals("0001")) {
                return -513;
            }
            if (sData.equals("0002")) {
                return -515;
            }
            return -516;
        }
        return 0;
    }

    public String[] GetTransInfo() {
        String[] ssData = new String[]{this.TransStat, this.SysDate, this.SysSeqId, this.GateId, this.MerPriv};
        return ssData;
    }

    public int DestorySession() {
        try {
            byte[] bTmp = new byte[]{68};
            this.write_read_tcp(1, bTmp, 'W');
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.sid != null) {
                this.sid.close();
            }
        }
        catch (IOException e) {
            System.out.println("Can not Close IOput " + e);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] write_read_tcp(int len, byte[] bSendData, char read_flag) {
        String sData = SecureLink.leftPad("" + len, 4, '0');
        try {
            byte[] bTmp = sData.getBytes();
            this.out.write(bTmp);
            this.out.write(bSendData);
            if (read_flag == 'W') {
                return null;
            }
            len = this.in.read(bTmp, 0, 4);
            if (len != 4) {
                return null;
            }
            len = Integer.parseInt(new String(bTmp));
            byte[] bRecvData = new byte[len];
            bTmp = new byte[100];
            int total = 0;
            block2: while (true) {
                if (total >= len) {
                    return bRecvData;
                }
                len = this.in.read(bTmp, 0, 100);
                if (len < 0) {
                    return null;
                }
                if (len == 0) continue;
                int i = 0;
                while (true) {
                    if (i >= len) {
                        total += len;
                        continue block2;
                    }
                    bRecvData[total + i] = bTmp[i];
                    ++i;
                }
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private int genDesKey() {
        byte[] deskey1 = new byte[8];
        byte[] deskey2 = new byte[8];
        Random rd = new Random();
        rd.nextBytes(deskey1);
        rd.nextBytes(deskey2);
        System.arraycopy(deskey1, 0, this.DesKey, 0, 8);
        System.arraycopy(deskey2, 0, this.DesKey, 8, 8);
        return 0;
    }

    static byte[] extract(byte[] bData, int start, int len) {
        byte[] bTmp = new byte[len];
        int i = 0;
        while (i < len) {
            bTmp[i] = bData[start + i];
            ++i;
        }
        return bTmp;
    }

    static void append(byte[] bData, int Start, String s, int len, char mode) {
        SecureLink.append(bData, Start, s.getBytes(), len, mode);
    }

    static void append(byte[] bData, int Start, byte[] bTmp, int len, char mode) {
        int l = bTmp.length;
        int bb = 48;
        if (mode == 'l') {
            bb = 32;
        }
        int i = 0;
        while (i < len) {
            bData[Start + i] = bb;
            ++i;
        }
        if (l > len) {
            l = len;
        }
        if (mode == 'l') {
            i = 0;
            while (i < l) {
                bData[Start + i] = bTmp[i];
                ++i;
            }
        } else {
            i = 0;
            while (i < l) {
                bData[Start + len - l + i] = bTmp[i];
                ++i;
            }
        }
    }

    public static String leftPad(String str, int len, char ch) {
        StringBuffer nstr = new StringBuffer(len);
        int p = len - str.length();
        int i = 0;
        while (i < len) {
            if (i < p) {
                nstr.append(ch);
            } else {
                nstr.append(str.charAt(i - p));
            }
            ++i;
        }
        return new String(nstr);
    }

    public int DecMsg(String MerId, String MerKeyFile, String MsgData) {
        boolean flag = this.privateKey.buildKey(MerId, 0, MerKeyFile);
        if (!flag) {
            System.out.println("build key error!");
            return -101;
        }
        int i = this.newDecData_J_Client(MsgData);
        if (i < 0) {
            System.out.println("decrypt msgdata error!");
            return -102;
        }
        return 0;
    }

    public int EncMsg(String PgKeyFile, String MsgData) {
        int ret;
        boolean flag = this.privateKey.buildKey("999999", 0, PgKeyFile);
        if (!flag) {
            System.out.println("build key error!");
            return -101;
        }
        try {
            ret = this.newEncData_J_Client(MsgData.getBytes("GBK"));
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("encoding msgdata error!");
            return -102;
        }
        if (ret < 0) {
            System.out.println("encrypt msgdata error!");
            return -102;
        }
        return 0;
    }
}

