/*
 * Decompiled with CFR 0.152.
 */
package chinapnr;

public class ShaHash {
    private int hashSize = 20;
    private byte[] hashBytes;
    private static final boolean USE_MODIFIED_SHA = true;
    private static final int SHA_BLOCKSIZE = 64;
    private static final int SHA_DIGESTSIZE = 20;
    private int[] digest = new int[5];
    private long bitCount;
    private byte[] dataB = new byte[64];
    private int[] dataI = new int[16];
    private static final int K1 = 1518500249;
    private static final int K2 = 1859775393;
    private static final int K3 = -1894007588;
    private static final int K4 = -899497514;
    private static final int h0init = 1732584193;
    private static final int h1init = -271733879;
    private static final int h2init = -1732584194;
    private static final int h3init = 271733878;
    private static final int h4init = -1009589776;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private int A;
    private int B;
    private int C;
    private int D;
    private int E;
    private int[] W = new int[80];

    public ShaHash() {
        this.hashBytes = new byte[20];
    }

    public void add(byte[] byArray, int n, int n2) {
        this.reset();
        this.shaUpdate(byArray, n, n2);
    }

    public static void copyBlock(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray2[n2 + i] = byArray[n + i];
        }
    }

    private static int f1(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private static int f2(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private static int f3(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    private static int f4(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private static void fillBlock(byte[] byArray, byte by) {
        ShaHash.fillBlock(byArray, 0, by, byArray.length);
    }

    private static void fillBlock(byte[] byArray, int n, byte by, int n2) {
        for (int i = n; i < n + n2; ++i) {
            byArray[i] = by;
        }
    }

    public byte[] get() {
        this.prepare();
        byte[] byArray = new byte[this.hashSize + 108];
        byte[] byArray2 = new byte[]{0, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        System.arraycopy(byArray2, 0, byArray, 0, 108);
        System.arraycopy(this.hashBytes, 0, byArray, 108, this.hashSize);
        return byArray;
    }

    public void prepare() {
        this.shaFinal();
        ShaHash.spreadIntsToBytes(this.digest, 0, this.hashBytes, 0, 5);
    }

    public void reset() {
        this.shaInit();
    }

    private static int rotateL(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    public void shaFinal() {
        int n = (int)(this.bitCount >>> 3) & 0x3F;
        this.dataB[n++] = -128;
        if (n > 56) {
            ShaHash.fillBlock(this.dataB, n, (byte)0, 64 - n);
            ShaHash.squashBytesToInts(this.dataB, 0, this.dataI, 0, 16);
            this.shaTransform();
            ShaHash.fillBlock(this.dataB, 0, (byte)0, 56);
        } else {
            ShaHash.fillBlock(this.dataB, n, (byte)0, 56 - n);
        }
        ShaHash.squashBytesToInts(this.dataB, 0, this.dataI, 0, 16);
        this.dataI[14] = (int)(this.bitCount >>> 32);
        this.dataI[15] = (int)(this.bitCount & 0xFFFFFFFFFFFFFFFFL);
        this.shaTransform();
    }

    private void shaInit() {
        this.digest[0] = 1732584193;
        this.digest[1] = -271733879;
        this.digest[2] = -1732584194;
        this.digest[3] = 271733878;
        this.digest[4] = -1009589776;
        this.bitCount = 0L;
    }

    public void shaTransform() {
        int n;
        for (n = 0; n < 16; ++n) {
            this.W[n] = this.dataI[n];
        }
        while (n < 80) {
            this.W[n] = this.W[n - 3] ^ this.W[n - 8] ^ this.W[n - 14] ^ this.W[n - 16];
            this.W[n] = ShaHash.rotateL(this.W[n], 1);
            ++n;
        }
        this.A = this.digest[0];
        this.B = this.digest[1];
        this.C = this.digest[2];
        this.D = this.digest[3];
        this.E = this.digest[4];
        for (n = 0; n < 20; ++n) {
            this.subRound1(n);
        }
        while (n < 40) {
            this.subRound2(n);
            ++n;
        }
        while (n < 60) {
            this.subRound3(n);
            ++n;
        }
        while (n < 80) {
            this.subRound4(n);
            ++n;
        }
        this.digest[0] = this.digest[0] + this.A;
        this.digest[1] = this.digest[1] + this.B;
        this.digest[2] = this.digest[2] + this.C;
        this.digest[3] = this.digest[3] + this.D;
        this.digest[4] = this.digest[4] + this.E;
    }

    public void shaUpdate(byte[] byArray, int n, int n2) {
        this.bitCount += (long)(n2 << 3);
        while (n2 >= 64) {
            ShaHash.copyBlock(byArray, n, this.dataB, 0, 64);
            ShaHash.squashBytesToInts(this.dataB, 0, this.dataI, 0, 16);
            this.shaTransform();
            n += 64;
            n2 -= 64;
        }
        ShaHash.copyBlock(byArray, n, this.dataB, 0, n2);
    }

    private static void spreadIntsToBytes(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray[n2 + i * 4] = (byte)(nArray[n + i] >>> 24);
            byArray[n2 + i * 4 + 1] = (byte)(nArray[n + i] >>> 16);
            byArray[n2 + i * 4 + 2] = (byte)(nArray[n + i] >>> 8);
            byArray[n2 + i * 4 + 3] = (byte)nArray[n + i];
        }
    }

    private static void squashBytesToInts(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            nArray[n2 + i] = (byArray[n + i * 4] & 0xFF) << 24 | (byArray[n + i * 4 + 1] & 0xFF) << 16 | (byArray[n + i * 4 + 2] & 0xFF) << 8 | byArray[n + i * 4 + 3] & 0xFF;
        }
    }

    private void subRound1(int n) {
        int n2 = ShaHash.rotateL(this.A, 5) + ShaHash.f1(this.B, this.C, this.D) + this.E + this.W[n] + 1518500249;
        this.E = this.D;
        this.D = this.C;
        this.C = ShaHash.rotateL(this.B, 30);
        this.B = this.A;
        this.A = n2;
    }

    private void subRound2(int n) {
        int n2 = ShaHash.rotateL(this.A, 5) + ShaHash.f2(this.B, this.C, this.D) + this.E + this.W[n] + 1859775393;
        this.E = this.D;
        this.D = this.C;
        this.C = ShaHash.rotateL(this.B, 30);
        this.B = this.A;
        this.A = n2;
    }

    private void subRound3(int n) {
        int n2 = ShaHash.rotateL(this.A, 5) + ShaHash.f3(this.B, this.C, this.D) + this.E + this.W[n] + -1894007588;
        this.E = this.D;
        this.D = this.C;
        this.C = ShaHash.rotateL(this.B, 30);
        this.B = this.A;
        this.A = n2;
    }

    private void subRound4(int n) {
        int n2 = ShaHash.rotateL(this.A, 5) + ShaHash.f4(this.B, this.C, this.D) + this.E + this.W[n] + -899497514;
        this.E = this.D;
        this.D = this.C;
        this.C = ShaHash.rotateL(this.B, 30);
        this.B = this.A;
        this.A = n2;
    }

    private static String toStringBlock(byte[] byArray) {
        return ShaHash.toStringBlock(byArray, 0, byArray.length);
    }

    private static String toStringBlock(byte[] byArray, int n, int n2) {
        String string = "0123456789abcdef";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n + n2; ++i) {
            stringBuffer.append(string.charAt(byArray[i] >>> 4 & 0xF));
            stringBuffer.append(string.charAt(byArray[i] & 0xF));
        }
        return String.valueOf(String.valueOf(stringBuffer));
    }
}

