/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.util;

import cfca.sadk.algorithm.common.PKIException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;

public class InitKeyStore {
    public static KeyStore initPKCS12KeyStore(byte[] pfxData, String pfxPWD) throws Exception {
        KeyStore ks = null;
        ByteArrayInputStream bis = null;
        try {
            ks = KeyStore.getInstance("PKCS12");
            char[] nPassword = null;
            nPassword = pfxPWD == null || pfxPWD.trim().equals("") ? null : pfxPWD.toCharArray();
            bis = new ByteArrayInputStream(pfxData);
            ks.load(bis, nPassword);
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw new PKIException("can not init the PKCS12 keyStore:" + e.getMessage());
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }

    public static KeyStore initJKSKeyStore(String jksFilePath, String jksPWD) throws Exception {
        FileInputStream fin = null;
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            fin = new FileInputStream(jksFilePath);
            char[] password = jksPWD.toCharArray();
            ks.load(fin, password);
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw new PKIException("can not get the JKS keyStore:" + e.getMessage());
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
    }

    public static KeyStore initJKSKeyStore(InputStream is, String jksPWD) throws Exception {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            char[] password = jksPWD.toCharArray();
            ks.load(is, password);
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw new PKIException("can not get the JKS keyStore:" + e.getMessage());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

