/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.envelope.rsa;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7EnvelopedData;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.RSAAndItsCloseSymAlgUtil;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.envelope.rsa.RSAEncryptedContentInfo;
import cfca.sadk.envelope.rsa.RSAEncryptedInputStream;
import cfca.sadk.envelope.rsa.RSAEnvelopedData;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.jni.JNISoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.BEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EnvelopedData;
import cfca.sadk.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientIdentifier;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cfca.sadk.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.io.FileOutputStream;

public class RSAEnvelopeUtil {
    private static byte[] IV_8 = new byte[]{50, 51, 52, 53, 54, 55, 56, 57};

    public static final byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts) throws Exception {
        return Base64.encode(RSAEnvelopeUtil.envelopeMesage_None64(sourceData, symmetricAlgorithm, receiverCerts, null));
    }

    public static final byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        return Base64.encode(RSAEnvelopeUtil.envelopeMesage_None64(sourceData, symmetricAlgorithm, receiverCerts, session));
    }

    private static byte[] envelopeMesage_None64(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws PKIException, Exception {
        byte[] key = RSAAndItsCloseSymAlgUtil.generateSecretKey(symmetricAlgorithm);
        IV_8 = RSAAndItsCloseSymAlgUtil.generateIV();
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        for (int i = 0; i < receiverCerts.length; ++i) {
            recipientInfos.add(RSAEnvelopeUtil.toRecipientInfo(receiverCerts[i], key, session));
        }
        String symmetricAlgorithmStr = symmetricAlgorithm;
        if (!Mechanism.isSymmetricAlgorithmValid(symmetricAlgorithmStr)) {
            throw new PKIException("can not support this symetric algorithm:" + symmetricAlgorithmStr);
        }
        Mechanism contentEncryptionAlg = null;
        if (symmetricAlgorithmStr.indexOf("CBC") != -1) {
            CBCParam cbc = new CBCParam();
            cbc.setIv(IV_8);
            contentEncryptionAlg = new Mechanism(symmetricAlgorithmStr, cbc);
        } else {
            contentEncryptionAlg = new Mechanism(symmetricAlgorithmStr);
        }
        boolean useJNI = false;
        if (session != null && session instanceof JNISoftLib) {
            useJNI = true;
        }
        byte[] encryptedData = RSAAndItsCloseSymAlgUtil.crypto(useJNI, true, key, sourceData, contentEncryptionAlg);
        BEROctetString encryptOctet = new BEROctetString(encryptedData);
        ASN1ObjectIdentifier tOID = (ASN1ObjectIdentifier)PKCS7EnvelopedData.MECH_OID.get(symmetricAlgorithmStr);
        AlgorithmIdentifier algId = RSAEnvelopeUtil.getAlgorithmIdentifier(contentEncryptionAlg, tOID);
        EncryptedContentInfo eci = new EncryptedContentInfo(PKCSObjectIdentifiers.data, algId, encryptOctet);
        EnvelopedData enData = new EnvelopedData(null, (ASN1Set)new DERSet(recipientInfos), eci, ASN1Set.getInstance(null));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.envelopedData, enData);
        return ASN1Parser.parseDERObj2Bytes(new CMSEnvelopedData(contentInfo).toASN1Structure());
    }

    private static AlgorithmIdentifier getAlgorithmIdentifier(Mechanism contentEncryptionAlg, ASN1ObjectIdentifier tOID) throws PKIException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(tOID, new DERNull());
        if (contentEncryptionAlg.getMechanismType().toUpperCase().indexOf("CBC") != -1) {
            Object param = contentEncryptionAlg.getParam();
            if (param == null) {
                throw new PKIException(PKIException.NULL_P7_ENVELOP_CBC_ERR, PKIException.NULL_P7_ENVELOP_CBC_ERR_DES);
            }
            CBCParam cbcParam = (CBCParam)contentEncryptionAlg.getParam();
            DEROctetString doct = new DEROctetString(cbcParam.getIv());
            algorithmIdentifier = new AlgorithmIdentifier(tOID, doct);
            return algorithmIdentifier;
        }
        return algorithmIdentifier;
    }

    private static RecipientInfo toRecipientInfo(X509Cert cert, byte[] symmetricKey, Session session) throws Exception {
        byte[] encryptedKey = null;
        encryptedKey = session != null && session instanceof JNISoftLib ? RSAAndItsCloseSymAlgUtil.rsaEncryptByJNI(true, cert.getPublicKey(), symmetricKey) : RSAAndItsCloseSymAlgUtil.rsaEncrypt(true, cert.getPublicKey(), symmetricKey);
        DEROctetString encKey = new DEROctetString(encryptedKey);
        SubjectKeyIdentifier sid = cert.getSubjectKeyIdentifier();
        if (sid == null) {
            throw new Exception("the cert has no extension data with SubjectKeyIdentifier,can not create envelope data");
        }
        AlgorithmIdentifier keyEncAlg = cert.getCertStructure().getSubjectPublicKeyInfo().getAlgorithm();
        KeyTransRecipientInfo ktr = new KeyTransRecipientInfo(new RecipientIdentifier(new DEROctetString(sid.getKeyIdentifier())), keyEncAlg, encKey);
        return new RecipientInfo(ktr);
    }

    public static final void envelopeFile(String sourceFilePath, String envelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts) throws Exception {
        RSAEnvelopeUtil.envelopeFile(sourceFilePath, envelopedFilePath, symmetricAlgorithm, receiverCerts, null);
    }

    public static final void envelopeFile(String sourceFilePath, String envelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        byte[] key = RSAAndItsCloseSymAlgUtil.generateSecretKey(symmetricAlgorithm);
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        for (int i = 0; i < receiverCerts.length; ++i) {
            recipientInfos.add(RSAEnvelopeUtil.toRecipientInfo(receiverCerts[i], key, session));
        }
        String symmetricAlgorithmStr = symmetricAlgorithm;
        if (!Mechanism.isSymmetricAlgorithmValid(symmetricAlgorithmStr)) {
            throw new PKIException("can not support this symetric algorithm:" + symmetricAlgorithmStr);
        }
        Mechanism contentEncryptionAlg = null;
        if (symmetricAlgorithmStr.indexOf("CBC") != -1) {
            CBCParam cbc = new CBCParam();
            cbc.setIv(IV_8);
            contentEncryptionAlg = new Mechanism(symmetricAlgorithmStr, cbc);
        } else {
            contentEncryptionAlg = new Mechanism(symmetricAlgorithmStr);
        }
        ASN1ObjectIdentifier tOID = (ASN1ObjectIdentifier)PKCS7EnvelopedData.MECH_OID.get(symmetricAlgorithm);
        AlgorithmIdentifier algId = RSAEnvelopeUtil.getAlgorithmIdentifier(contentEncryptionAlg, tOID);
        boolean useJNIFlag = false;
        if (session != null && session instanceof JNISoftLib) {
            useJNIFlag = true;
        }
        RSAEncryptedInputStream encryptStream = new RSAEncryptedInputStream(useJNIFlag, new File(sourceFilePath), key, contentEncryptionAlg);
        RSAEncryptedContentInfo sm2Eci = new RSAEncryptedContentInfo(PKCSObjectIdentifiers.encryptedData, algId, encryptStream);
        RSAEnvelopedData enData = new RSAEnvelopedData(null, new DERSet(recipientInfos), sm2Eci, null);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.envelopedData, enData);
        File f = new File(envelopedFilePath);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(envelopedFilePath);
        DEROutputStream dos = new DEROutputStream(fos);
        dos.writeObject(contentInfo);
        dos.close();
    }
}

