/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.license;

import cfca.sadk.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public final class LicenseParser {
    private static String strDefaultKey = "license";
    private static final String SPLITSTRING = "**";

    public static void loadLicenseFromInputStream(Properties prop, InputStream in) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, CertificateException, SignatureException {
        byte[] fileData = new byte[in.available()];
        in.read(fileData);
        in.close();
        String license = new String(fileData, "UTF-8");
        int spLength = SPLITSTRING.length();
        int idxOf2edAsterisk = license.lastIndexOf(SPLITSTRING);
        int idxOf1stAsterisk = license.substring(0, idxOf2edAsterisk).lastIndexOf(SPLITSTRING);
        char lsch = license.charAt(8);
        int lsLength = lsch == '\r' ? 2 : 1;
        String licenseInfo = license.substring(8 + lsLength, idxOf1stAsterisk);
        String encodedEncryptedCertData = license.substring(idxOf1stAsterisk + spLength, idxOf2edAsterisk);
        String encodedSignedData = license.substring(idxOf2edAsterisk + spLength);
        byte[] signedData = Base64.decode(encodedSignedData);
        byte[] decodedEncryptedCertData = Base64.decode(encodedEncryptedCertData);
        Key seKey = LicenseParser.getKey(strDefaultKey.getBytes("UTF-8"));
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, seKey);
        byte[] decodedDecryptedData = cipher.doFinal(decodedEncryptedCertData);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(decodedDecryptedData));
        Signature signature = Signature.getInstance(cert.getSigAlgName());
        signature.initVerify(cert);
        signature.update(licenseInfo.getBytes("UTF-8"));
        if (signature.verify(signedData)) {
            prop.load(new ByteArrayInputStream(licenseInfo.getBytes("UTF-8")));
        }
    }

    private static Key getKey(byte[] arrBTmp) {
        byte[] arrB = new byte[8];
        for (int i = 0; i < arrBTmp.length && i < arrB.length; ++i) {
            arrB[i] = arrBTmp[i];
        }
        SecretKeySpec key = new SecretKeySpec(arrB, "DES");
        return key;
    }
}

