/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1GeneralizedTime;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.oiw.ElGamalParameter;
import cfca.sadk.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.CRLReason;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.org.bouncycastle.asn1.x509.ExtensionsGenerator;
import cfca.sadk.org.bouncycastle.asn1.x509.GeneralName;
import cfca.sadk.org.bouncycastle.asn1.x509.GeneralNames;
import cfca.sadk.org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import cfca.sadk.org.bouncycastle.asn1.x509.KeyUsage;
import cfca.sadk.org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.TBSCertList;
import cfca.sadk.org.bouncycastle.asn1.x509.TBSCertificate;
import cfca.sadk.org.bouncycastle.asn1.x509.Time;
import cfca.sadk.org.bouncycastle.asn1.x509.V1TBSCertificateGenerator;
import cfca.sadk.org.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import cfca.sadk.org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import cfca.sadk.org.bouncycastle.asn1.x509.X509Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.X509Extensions;
import cfca.sadk.org.bouncycastle.asn1.x509.X509Name;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.encoders.Base64;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class GenerationTest
extends SimpleTest {
    private byte[] v1Cert = Base64.decode("MIGtAgEBMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMMAkFVMRYwFAYDVQQKDA1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAxMlowNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMTAaMA0GCSqGSIb3DQEBAQUAAwkAMAYCAQECAQI=");
    private byte[] v3Cert = Base64.decode("MIIBSKADAgECAgECMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMMAkFVMRYwFAYDVQQKDA1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAwMlowNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMjAYMBAGBisOBwIBATAGAgEBAgECAwQAAgEDo4GVMIGSMGEGA1UdIwEB/wRXMFWAFDZPdpHPzKi7o8EJokkQU2uqCHRRoTqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAyggECMCAGA1UdDgEB/wQWBBQ2T3aRz8you6PBCaJJEFNrqgh0UTALBgNVHQ8EBAMCBBA=");
    private byte[] v3CertNullSubject = Base64.decode("MIHGoAMCAQICAQIwDQYJKoZIhvcNAQEEBQAwJTELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUwHhcNNzAwMTAxMDAwMDAxWhcNNzAwMTAxMDAwMDAyWjAAMBgwEAYGKw4HAgEBMAYCAQECAQIDBAACAQOjSjBIMEYGA1UdEQEB/wQ8MDqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAy");
    private byte[] v2CertList = Base64.decode("MIIBQwIBATANBgkqhkiG9w0BAQUFADAlMQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZRcNNzAwMTAxMDAwMDAwWhcNNzAwMTAxMDAwMDAyWjAiMCACAQEXDTcwMDEwMTAwMDAwMVowDDAKBgNVHRUEAwoBCqCBxTCBwjBhBgNVHSMBAf8EVzBVgBQ2T3aRz8you6PBCaJJEFNrqgh0UaE6pDgwNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMoIBAjBDBgNVHRIEPDA6pDgwNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMzAKBgNVHRQEAwIBATAMBgNVHRwBAf8EAjAA");

    private void tbsV1CertGen() throws IOException {
        V1TBSCertificateGenerator gen = new V1TBSCertificateGenerator();
        Date startDate = new Date(1000L);
        Date endDate = new Date(12000L);
        gen.setSerialNumber(new ASN1Integer(1L));
        gen.setStartDate(new Time(startDate));
        gen.setEndDate(new Time(endDate));
        gen.setIssuer(new X500Name("CN=AU,O=Bouncy Castle"));
        gen.setSubject(new X500Name("CN=AU,O=Bouncy Castle,OU=Test 1"));
        gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, DERNull.INSTANCE));
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPublicKeyStructure(BigInteger.valueOf(1L), BigInteger.valueOf(2L)));
        gen.setSubjectPublicKeyInfo(info);
        TBSCertificate tbs = gen.generateTBSCertificate();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(tbs);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v1Cert)) {
            this.fail("failed v1 cert generation");
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.v1Cert));
        ASN1Primitive o = aIn.readObject();
        bOut = new ByteArrayOutputStream();
        aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(o);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v1Cert)) {
            this.fail("failed v1 cert read back test");
        }
    }

    private AuthorityKeyIdentifier createAuthorityKeyId(SubjectPublicKeyInfo info, X500Name name, int sNumber) {
        GeneralName genName = new GeneralName(name);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(genName);
        return new AuthorityKeyIdentifier(info, GeneralNames.getInstance(new DERSequence(v)), BigInteger.valueOf(sNumber));
    }

    private void tbsV3CertGen() throws IOException {
        V3TBSCertificateGenerator gen = new V3TBSCertificateGenerator();
        Date startDate = new Date(1000L);
        Date endDate = new Date(2000L);
        gen.setSerialNumber(new ASN1Integer(2L));
        gen.setStartDate(new Time(startDate));
        gen.setEndDate(new Time(endDate));
        gen.setIssuer(new X500Name("CN=AU,O=Bouncy Castle"));
        gen.setSubject(new X500Name("CN=AU,O=Bouncy Castle,OU=Test 2"));
        gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, DERNull.INSTANCE));
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new ASN1Integer(3L));
        gen.setSubjectPublicKeyInfo(info);
        Vector<ASN1ObjectIdentifier> order = new Vector<ASN1ObjectIdentifier>();
        Hashtable<ASN1ObjectIdentifier, X509Extension> extensions = new Hashtable<ASN1ObjectIdentifier, X509Extension>();
        order.addElement(X509Extension.authorityKeyIdentifier);
        order.addElement(X509Extension.subjectKeyIdentifier);
        order.addElement(X509Extension.keyUsage);
        extensions.put(X509Extension.authorityKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(this.createAuthorityKeyId(info, new X500Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2))));
        extensions.put(X509Extension.subjectKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(new SubjectKeyIdentifier(GenerationTest.getDigest(info)))));
        extensions.put(X509Extension.keyUsage, new X509Extension(false, (ASN1OctetString)new DEROctetString(new KeyUsage(16))));
        X509Extensions ex = new X509Extensions(order, extensions);
        gen.setExtensions(ex);
        TBSCertificate tbs = gen.generateTBSCertificate();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(tbs);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v3Cert)) {
            this.fail("failed v3 cert generation");
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.v3Cert));
        ASN1Primitive o = aIn.readObject();
        bOut = new ByteArrayOutputStream();
        aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(o);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v3Cert)) {
            this.fail("failed v3 cert read back test");
        }
    }

    private void tbsV3CertGenWithNullSubject() throws IOException {
        V3TBSCertificateGenerator gen;
        block4: {
            gen = new V3TBSCertificateGenerator();
            Date startDate = new Date(1000L);
            Date endDate = new Date(2000L);
            gen.setSerialNumber(new ASN1Integer(2L));
            gen.setStartDate(new Time(startDate));
            gen.setEndDate(new Time(endDate));
            gen.setIssuer(new X500Name("CN=AU,O=Bouncy Castle"));
            gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, DERNull.INSTANCE));
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new ASN1Integer(3L));
            gen.setSubjectPublicKeyInfo(info);
            try {
                gen.generateTBSCertificate();
                this.fail("null subject not caught!");
            }
            catch (IllegalStateException e) {
                if (e.getMessage().equals("not all mandatory fields set in V3 TBScertificate generator")) break block4;
                this.fail("unexpected exception", e);
            }
        }
        Vector<ASN1ObjectIdentifier> order = new Vector<ASN1ObjectIdentifier>();
        Hashtable<ASN1ObjectIdentifier, X509Extension> extensions = new Hashtable<ASN1ObjectIdentifier, X509Extension>();
        order.addElement(X509Extension.subjectAlternativeName);
        extensions.put(X509Extension.subjectAlternativeName, new X509Extension(true, (ASN1OctetString)new DEROctetString(new GeneralNames(new GeneralName(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"))))));
        X509Extensions ex = new X509Extensions(order, extensions);
        gen.setExtensions(ex);
        TBSCertificate tbs = gen.generateTBSCertificate();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(tbs);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v3CertNullSubject)) {
            this.fail("failed v3 null sub cert generation");
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.v3CertNullSubject));
        ASN1Primitive o = aIn.readObject();
        bOut = new ByteArrayOutputStream();
        aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(o);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v3CertNullSubject)) {
            this.fail("failed v3 null sub cert read back test");
        }
    }

    private void tbsV2CertListGen() throws IOException {
        V2TBSCertListGenerator gen = new V2TBSCertListGenerator();
        gen.setIssuer(new X500Name("CN=AU,O=Bouncy Castle"));
        gen.addCRLEntry(new ASN1Integer(1L), new Time(new Date(1000L)), 10);
        gen.setNextUpdate(new Time(new Date(2000L)));
        gen.setThisUpdate(new Time(new Date(500L)));
        gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, DERNull.INSTANCE));
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new ASN1Integer(3L));
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.authorityKeyIdentifier, true, this.createAuthorityKeyId(info, new X500Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2));
        extGen.addExtension(Extension.issuerAlternativeName, false, new GeneralNames(new GeneralName(new X500Name("CN=AU,O=Bouncy Castle,OU=Test 3"))));
        extGen.addExtension(Extension.cRLNumber, false, new ASN1Integer(1L));
        extGen.addExtension(Extension.issuingDistributionPoint, true, IssuingDistributionPoint.getInstance(new DERSequence()));
        Extensions ex = extGen.generate();
        gen.setExtensions(ex);
        TBSCertList tbs = gen.generateTBSCertList();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(tbs);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v2CertList)) {
            System.out.println(new String(Base64.encode(bOut.toByteArray())));
            this.fail("failed v2 cert list generation");
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.v2CertList));
        ASN1Primitive o = aIn.readObject();
        bOut = new ByteArrayOutputStream();
        aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(o);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v2CertList)) {
            this.fail("failed v2 cert list read back test");
        }
        gen.addCRLEntry(new ASN1Integer(1L), new Time(new Date(1000L)), 10);
        gen.addCRLEntry(new ASN1Integer(2L), new Time(new Date(1000L)), 3, new ASN1GeneralizedTime(new Date(2000L)));
        TBSCertList crl = gen.generateTBSCertList();
        TBSCertList.CRLEntry[] entries = crl.getRevokedCertificates();
        for (int i = 0; i != entries.length; ++i) {
            CRLReason r;
            Extension ext;
            Extensions extensions;
            TBSCertList.CRLEntry entry = entries[i];
            if (entry.getUserCertificate().equals(new ASN1Integer(1L))) {
                extensions = entry.getExtensions();
                ext = extensions.getExtension(Extension.reasonCode);
                r = CRLReason.getInstance(ext.getParsedValue());
                if (r.getValue().intValue() == 10) continue;
                this.fail("reason code mismatch");
                continue;
            }
            if (!entry.getUserCertificate().equals(new ASN1Integer(2L))) continue;
            extensions = entry.getExtensions();
            ext = extensions.getExtension(Extension.reasonCode);
            r = CRLReason.getInstance(ext.getParsedValue());
            if (r.getValue().intValue() != 3) {
                this.fail("reason code mismatch");
            }
            ext = extensions.getExtension(Extension.invalidityDate);
            ASN1GeneralizedTime t = ASN1GeneralizedTime.getInstance(ext.getParsedValue());
            try {
                if (t.getDate().equals(new Date(2000L))) continue;
                this.fail("invalidity date mismatch");
                continue;
            }
            catch (ParseException e) {
                this.fail("can't parse date", e);
            }
        }
    }

    public void performTest() throws Exception {
        this.tbsV1CertGen();
        this.tbsV3CertGen();
        this.tbsV3CertGenWithNullSubject();
        this.tbsV2CertListGen();
    }

    public String getName() {
        return "Generation";
    }

    private static byte[] getDigest(SubjectPublicKeyInfo spki) {
        SHA1Digest digest = new SHA1Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        byte[] bytes = spki.getPublicKeyData().getBytes();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        return resBuf;
    }

    public static void main(String[] args) {
        GenerationTest.runTest(new GenerationTest());
    }
}

