/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cms.test;

import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cert.jcajce.JcaCRLStore;
import cfca.sadk.org.bouncycastle.cert.jcajce.JcaCertStore;
import cfca.sadk.org.bouncycastle.cms.CMSCompressedDataStreamGenerator;
import cfca.sadk.org.bouncycastle.cms.CMSDigestedData;
import cfca.sadk.org.bouncycastle.cms.CMSSignedDataParser;
import cfca.sadk.org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import cfca.sadk.org.bouncycastle.cms.CMSTypedStream;
import cfca.sadk.org.bouncycastle.cms.SignerInformation;
import cfca.sadk.org.bouncycastle.cms.SignerInformationStore;
import cfca.sadk.org.bouncycastle.cms.jcajce.JcaSignerInfoVerifierBuilder;
import cfca.sadk.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import cfca.sadk.org.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import cfca.sadk.org.bouncycastle.cms.jcajce.ZlibCompressor;
import cfca.sadk.org.bouncycastle.cms.test.CMSTestSetup;
import cfca.sadk.org.bouncycastle.cms.test.CMSTestUtil;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.operator.DigestCalculatorProvider;
import cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import cfca.sadk.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.Store;
import cfca.sadk.org.bouncycastle.util.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.Security;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class MiscDataStreamTest
extends TestCase {
    private static final String BC = "BC";
    private static byte[] data = Base64.decode("TUlNRS1WZXJzaW9uOiAxLjAKQ29udGVudC1UeXBlOiBhcHBsaWNhdGlvbi9vY3RldC1zdHJlYW0KQ29udGVudC1UcmFuc2Zlci1FbmNvZGluZzogYmluYXJ5CkNvbnRlbnQtRGlzcG9zaXRpb246IGF0dGFjaG1lbnQ7IGZpbGVuYW1lPWRvYy5iaW4KClRoaXMgaXMgYSB2ZXJ5IGh1Z2Ugc2VjcmV0LCBtYWRlIHdpdGggb3BlbnNzbAoKCgo=");
    private static byte[] digestedData = Base64.decode("MIIBGAYJKoZIhvcNAQcFoIIBCTCCAQUCAQAwCwYJYIZIAWUDBAIBMIHQBgkqhkiG9w0BBwGggcIEgb9NSU1FLVZlcnNpb246IDEuMApDb250ZW50LVR5cGU6IGFwcGxpY2F0aW9uL29jdGV0LXN0cmVhbQpDb250ZW50LVRyYW5zZmVyLUVuY29kaW5nOiBiaW5hcnkKQ29udGVudC1EaXNwb3NpdGlvbjogYXR0YWNobWVudDsgZmlsZW5hbWU9ZG9jLmJpbgoKVGhpcyBpcyBhIHZlcnkgaHVnZSBzZWNyZXQsIG1hZGUgd2l0aCBvcGVuc3NsCgoKCgQgHLG72tSYW0LgcxOA474iwdCvKyhnaV4RloWTAvkq+do=");
    private static final String TEST_MESSAGE = "Hello World!";
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static KeyPair _origDsaKP;
    private static X509Certificate _origDsaCert;
    private static X509CRL _signCrl;
    private static X509CRL _origCrl;
    private static boolean _initialised;
    private static final JcaX509CertSelectorConverter selectorConverter;
    private static final DigestCalculatorProvider digCalcProv;

    public MiscDataStreamTest(String name) {
        super(name);
    }

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            Security.addProvider(new BouncyCastleProvider());
            _signDN = "O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _signKP, _signDN);
            _origDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _signKP, _signDN);
            _origDsaKP = CMSTestUtil.makeDsaKeyPair();
            _origDsaCert = CMSTestUtil.makeCertificate(_origDsaKP, _origDN, _signKP, _signDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
            _signCrl = CMSTestUtil.makeCrl(_signKP);
            _origCrl = CMSTestUtil.makeCrl(_origKP);
        }
    }

    private void verifySignatures(CMSSignedDataParser sp, byte[] contentDigest) throws Exception {
        Store certStore = sp.getCertificates();
        SignerInformationStore signers = sp.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certStore.getMatches(signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            MiscDataStreamTest.assertEquals((boolean)true, (boolean)signer.verify(new JcaSignerInfoVerifierBuilder(digCalcProv).setProvider(BC).build(cert)));
            if (contentDigest == null) continue;
            MiscDataStreamTest.assertTrue((boolean)MessageDigest.isEqual(contentDigest, signer.getContentDigest()));
        }
    }

    private void verifySignatures(CMSSignedDataParser sp) throws Exception {
        this.verifySignatures(sp, null);
    }

    private void verifyEncodedData(ByteArrayOutputStream bOut) throws Exception {
        CMSSignedDataParser sp = new CMSSignedDataParser(digCalcProv, bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
        sp.close();
    }

    private void checkSigParseable(byte[] sig) throws Exception {
        CMSSignedDataParser sp = new CMSSignedDataParser(digCalcProv, sig);
        sp.getVersion();
        CMSTypedStream sc = sp.getSignedContent();
        if (sc != null) {
            sc.drain();
        }
        sp.getCertificates();
        sp.getSignerInfos();
        sp.close();
    }

    public void testSHA1WithRSA() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        crlList.add(_signCrl);
        crlList.add(_origCrl);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).build("SHA1withRSA", _origKP.getPrivate(), _origCert));
        gen.addCertificates(new JcaCertStore(certList));
        gen.addCRLs(new JcaCRLStore(crlList));
        OutputStream sigOut = gen.open(bOut);
        CMSCompressedDataStreamGenerator cGen = new CMSCompressedDataStreamGenerator();
        OutputStream cOut = cGen.open(sigOut, new ZlibCompressor());
        cOut.write(TEST_MESSAGE.getBytes());
        cOut.close();
        sigOut.close();
        this.checkSigParseable(bOut.toByteArray());
        ByteArrayOutputStream cDataOut = new ByteArrayOutputStream();
        cOut = cGen.open(cDataOut, new ZlibCompressor());
        cOut.write(TEST_MESSAGE.getBytes());
        cOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(digCalcProv, new CMSTypedStream(new ByteArrayInputStream(cDataOut.toByteArray())), bOut.toByteArray());
        sp.getSignedContent().drain();
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(sp, md.digest(cDataOut.toByteArray()));
    }

    public void testDigestedData() throws Exception {
        CMSDigestedData digData = new CMSDigestedData(digestedData);
        MiscDataStreamTest.assertTrue((boolean)Arrays.areEqual(data, (byte[])digData.getDigestedContent().getContent()));
        MiscDataStreamTest.assertTrue((boolean)digData.verify(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()));
    }

    public static Test suite() throws Exception {
        MiscDataStreamTest.init();
        return new CMSTestSetup((Test)new TestSuite(MiscDataStreamTest.class));
    }

    static {
        _initialised = false;
        selectorConverter = new JcaX509CertSelectorConverter();
        try {
            digCalcProv = new JcaDigestCalculatorProviderBuilder().build();
        }
        catch (OperatorCreationException e) {
            throw new IllegalStateException("can't create default provider!!!");
        }
    }
}

