/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cms.test;

import cfca.sadk.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.operator.DigestCalculator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

class SHA1DigestCalculator
implements DigestCalculator {
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    SHA1DigestCalculator() {
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
    }

    public OutputStream getOutputStream() {
        return this.bOut;
    }

    public byte[] getDigest() {
        byte[] bytes = this.bOut.toByteArray();
        this.bOut.reset();
        SHA1Digest sha1 = new SHA1Digest();
        sha1.update(bytes, 0, bytes.length);
        byte[] digest = new byte[sha1.getDigestSize()];
        sha1.doFinal(digest, 0);
        return digest;
    }
}

