/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.ec.test;

import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.ec.ECElGamalDecryptor;
import cfca.sadk.org.bouncycastle.crypto.ec.ECElGamalEncryptor;
import cfca.sadk.org.bouncycastle.crypto.ec.ECNewPublicKeyTransform;
import cfca.sadk.org.bouncycastle.crypto.ec.ECNewRandomnessTransform;
import cfca.sadk.org.bouncycastle.crypto.ec.ECPair;
import cfca.sadk.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import cfca.sadk.org.bouncycastle.math.ec.ECConstants;
import cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECTransformationTest
extends SimpleTest {
    public String getName() {
        return "ECTransformationTest";
    }

    public void performTest() throws Exception {
        BigInteger n = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
        ECCurve.Fp curve = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16), n, ECConstants.ONE);
        ECDomainParameters params = new ECDomainParameters(curve, curve.decodePoint(Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), n);
        ECPublicKeyParameters pubKey = new ECPublicKeyParameters(curve.decodePoint(Hex.decode("0262b12d60690cdcf330babab6e69763b471f994dd702d16a5")), params);
        ECPrivateKeyParameters priKey = new ECPrivateKeyParameters(new BigInteger("651056770906015076056810763456358567190100156695615665659"), params);
        ParametersWithRandom pRandom = new ParametersWithRandom(pubKey, new SecureRandom());
        this.doTest(priKey, pRandom, BigInteger.valueOf(20L));
        BigInteger rand = new BigInteger(pubKey.getParameters().getN().bitLength() - 1, new SecureRandom());
        this.doTest(priKey, pRandom, rand);
        this.doSameKeyTest(priKey, pRandom, rand);
    }

    private void doTest(ECPrivateKeyParameters priKey, ParametersWithRandom pRandom, BigInteger value) {
        ECPoint data = priKey.getParameters().getG().multiply(value);
        ECElGamalEncryptor encryptor = new ECElGamalEncryptor();
        encryptor.init(pRandom);
        ECPair pair = encryptor.encrypt(data);
        ECKeyPairGenerator ecGen = new ECKeyPairGenerator();
        ecGen.init(new ECKeyGenerationParameters(priKey.getParameters(), new SecureRandom()));
        AsymmetricCipherKeyPair reEncKP = ecGen.generateKeyPair();
        ECNewPublicKeyTransform ecr = new ECNewPublicKeyTransform();
        ecr.init(reEncKP.getPublic());
        ECPair srcPair = pair;
        pair = ecr.transform(srcPair);
        ECElGamalDecryptor decryptor = new ECElGamalDecryptor();
        decryptor.init(priKey);
        ECPoint p = decryptor.decrypt(new ECPair(srcPair.getX(), pair.getY()));
        decryptor.init(reEncKP.getPrivate());
        ECPoint result = decryptor.decrypt(new ECPair(pair.getX(), p));
        if (!data.equals(result)) {
            this.fail("point pair failed to decrypt back to original");
        }
    }

    private void doSameKeyTest(ECPrivateKeyParameters priKey, ParametersWithRandom pRandom, BigInteger value) {
        ECPoint data = priKey.getParameters().getG().multiply(value);
        ECElGamalEncryptor encryptor = new ECElGamalEncryptor();
        encryptor.init(pRandom);
        ECPair pair = encryptor.encrypt(data);
        ECNewRandomnessTransform ecr = new ECNewRandomnessTransform();
        ecr.init(pRandom);
        ECPair srcPair = pair;
        pair = ecr.transform(srcPair);
        ECElGamalDecryptor decryptor = new ECElGamalDecryptor();
        decryptor.init(priKey);
        ECPoint result = decryptor.decrypt(pair);
        if (!data.equals(result)) {
            this.fail("point pair failed to decrypt back to original");
        }
    }

    public static void main(String[] args) {
        ECTransformationTest.runTest(new ECTransformationTest());
    }
}

