/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.prng.test;

import cfca.sadk.org.bouncycastle.crypto.prng.FixedSecureRandom;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class FixedSecureRandomTest
extends SimpleTest {
    byte[] base = Hex.decode("deadbeefdeadbeef");
    byte[] r1 = Hex.decode("cafebabecafebabe");
    byte[] r2 = Hex.decode("ffffffffcafebabedeadbeef");

    public String getName() {
        return "FixedSecureRandom";
    }

    public void performTest() throws Exception {
        byte[] seed;
        FixedSecureRandom fixed = new FixedSecureRandom(this.base);
        byte[] buf = new byte[8];
        fixed.nextBytes(buf);
        if (!Arrays.areEqual(buf, this.base)) {
            this.fail("wrong data returned");
        }
        if (!Arrays.areEqual(seed = (fixed = new FixedSecureRandom(this.base)).generateSeed(8), this.base)) {
            this.fail("wrong seed data returned");
        }
        if (!fixed.isExhausted()) {
            this.fail("not exhausted");
        }
        if (!Arrays.areEqual(seed = (fixed = new FixedSecureRandom(new byte[][]{this.r1, this.r2})).generateSeed(12), Hex.decode("cafebabecafebabeffffffff"))) {
            this.fail("wrong seed data returned - composite");
        }
        fixed.nextBytes(buf);
        if (!Arrays.areEqual(buf, Hex.decode("cafebabedeadbeef"))) {
            this.fail("wrong data returned");
        }
    }

    public static void main(String[] args) {
        FixedSecureRandomTest.runTest(new FixedSecureRandomTest());
    }
}

