/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.test;

import cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import cfca.sadk.org.bouncycastle.crypto.BufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class BlockCipherVectorTest
extends SimpleTest {
    int id;
    BlockCipher engine;
    CipherParameters param;
    byte[] input;
    byte[] output;

    public BlockCipherVectorTest(int id, BlockCipher engine, CipherParameters param, String input, String output) {
        this.id = id;
        this.engine = engine;
        this.param = param;
        this.input = Hex.decode(input);
        this.output = Hex.decode(output);
    }

    public String getName() {
        return this.engine.getAlgorithmName() + " Vector Test " + this.id;
    }

    public void performTest() throws Exception {
        BufferedBlockCipher cipher = new BufferedBlockCipher(this.engine);
        cipher.init(true, this.param);
        byte[] out = new byte[this.input.length];
        int len1 = cipher.processBytes(this.input, 0, this.input.length, out, 0);
        cipher.doFinal(out, len1);
        if (!this.areEqual(out, this.output)) {
            this.fail("failed - expected " + new String(Hex.encode(this.output)) + " got " + new String(Hex.encode(out)));
        }
        cipher.init(false, this.param);
        int len2 = cipher.processBytes(this.output, 0, this.output.length, out, 0);
        cipher.doFinal(out, len2);
        if (!this.areEqual(this.input, out)) {
            this.fail("failed reversal got " + new String(Hex.encode(out)));
        }
    }
}

