/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.test;

import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.ShortenedDigest;
import cfca.sadk.org.bouncycastle.util.Memoable;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class ShortenedDigestTest
extends SimpleTest {
    public void performTest() {
        Memoable d = new SHA1Digest();
        ShortenedDigest sd = new ShortenedDigest(new SHA1Digest(), 10);
        if (sd.getDigestSize() != 10) {
            this.fail("size check wrong for SHA-1");
        }
        if (sd.getByteLength() != d.getByteLength()) {
            this.fail("byte length check wrong for SHA-1");
        }
        sd.doFinal(new byte[10], 0);
        d = new SHA512Digest();
        sd = new ShortenedDigest(new SHA512Digest(), 20);
        if (sd.getDigestSize() != 20) {
            this.fail("size check wrong for SHA-512");
        }
        if (sd.getByteLength() != d.getByteLength()) {
            this.fail("byte length check wrong for SHA-512");
        }
        sd.doFinal(new byte[20], 0);
        try {
            new ShortenedDigest(null, 20);
            this.fail("null parameter not caught");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new ShortenedDigest(new SHA1Digest(), 50);
            this.fail("short digest not caught");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public String getName() {
        return "ShortenedDigest";
    }

    public static void main(String[] args) {
        ShortenedDigestTest.runTest(new ShortenedDigestTest());
    }
}

